/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.io.PrintWriter;
import java.io.Writer;
import mulesoft.common.util.Files;
import mulesoft.database.DbMacro;
import mulesoft.database.introspect.MetadataRetriever;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SchemaObject;
import mulesoft.database.introspect.TableInfo;
import org.jetbrains.annotations.Nullable;

public class ViewInfo
extends SchemaObject<ViewInfo> {
    private boolean notLoaded = true;
    private String viewSql = null;
    private static final long serialVersionUID = 7885789463303626821L;

    ViewInfo(SchemaInfo schema, String name, @Nullable String remarks) {
        super(schema, name, remarks);
    }

    public String asQName() {
        return TableInfo.getQName(this.getSchema().getPlainName(), this.getName());
    }

    public void dumpSql(PrintWriter writer, boolean create) {
        this.loadAll();
        PrintWriter w = Files.printWriter((Writer)writer);
        w.print((Object)(create ? "create view" : DbMacro.AlterView));
        w.printf(" %s as\n\t%s;;", this.asQName(), this.viewSql);
        w.println();
        w.println();
        w.printf("%s %s is '%s';;", DbMacro.CommentOnView, this.asQName(), ViewInfo.quoteViewSql(this.viewSql));
        w.println();
    }

    public void loadAll() {
        if (this.notLoaded) {
            this.viewSql = this.getRetriever().getViewSql(this.getSchema(), this.getName());
        }
        this.notLoaded = false;
    }

    @Override
    public boolean sameAs(ViewInfo to) {
        this.loadAll();
        to.loadAll();
        return this.viewSql.equals(to.viewSql);
    }

    private MetadataRetriever getRetriever() {
        return this.getSchema().getIntrospector().getRetriever();
    }

    public static String quoteViewSql(String viewSql) {
        return viewSql.trim().replace("\n", " ").replace("        ", "").replace("'", "''");
    }
}

