/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect.delta;

import java.io.PrintWriter;
import java.io.Writer;
import mulesoft.common.util.Files;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.delta.MdDelta;
import mulesoft.database.introspect.delta.SequenceDiffer;
import mulesoft.database.introspect.delta.TableDeltas;
import mulesoft.database.introspect.delta.TableDiffer;
import mulesoft.database.introspect.delta.ViewsDiffer;

public class DeltaGenerator {
    private final SequenceDiffer sequenceDiffer;
    private final TableDiffer tableDiffer;
    private final ViewsDiffer viewsDiffer;

    public DeltaGenerator(SchemaInfo from, SchemaInfo to) {
        this.tableDiffer = new TableDiffer(from, to);
        this.sequenceDiffer = new SequenceDiffer(from, to);
        this.viewsDiffer = new ViewsDiffer(from, to);
    }

    public MdDelta diffSequences() {
        return this.sequenceDiffer.diff();
    }

    public TableDeltas diffTables() {
        return this.tableDiffer.diff();
    }

    public MdDelta diffViews() {
        return this.viewsDiffer.diff();
    }

    public void generate(Writer writer) {
        PrintWriter pw = Files.printWriter((Writer)writer);
        this.sequenceDiffer.generateCreates(pw);
        this.tableDiffer.generate(pw);
        this.sequenceDiffer.generateDrops(pw);
        this.viewsDiffer.generate(pw);
    }

    public boolean isMinor() {
        return this.diffSequences().isMinor() && this.diffTables().isMinor();
    }
}

