/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect.delta;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.core.Tuple;
import mulesoft.common.core.Tuple3;
import mulesoft.database.introspect.MetadataObject;
import mulesoft.database.introspect.delta.MdDelta;

abstract class MdDiffer<T extends MetadataObject<T>>
implements MdDelta {
    private final List<String> changed;
    private final List<String> fromOnly;
    private boolean mustDiff;
    private final Map<String, String> renamed;
    private final String schemaName;
    private final List<String> toOnly;

    MdDiffer(String schemaName) {
        this.schemaName = schemaName;
        this.toOnly = new ArrayList<String>();
        this.fromOnly = new ArrayList<String>();
        this.changed = new ArrayList<String>();
        this.renamed = new LinkedHashMap<String, String>();
        this.mustDiff = true;
    }

    @Override
    public void createElements(PrintWriter pw) {
        for (String name : this.getToOnly()) {
            this.generateCreate(pw, this.getTo(name));
        }
    }

    @Override
    public void dropElements(PrintWriter pw) {
        for (String name : this.getFromOnly()) {
            this.generateDrop(pw, name);
        }
    }

    @Override
    public void generate(PrintWriter pw) {
        this.dropElements(pw);
        for (Map.Entry<String, String> e : this.getRenamed().entrySet()) {
            if (e.getKey().equals(e.getValue())) continue;
            this.generateRename(pw, e.getKey(), e.getValue());
        }
        this.createElements(pw);
        for (String name : this.getChanged()) {
            this.generateAlter(pw, name);
        }
    }

    @Override
    public List<String> getChanged() {
        return this.changed;
    }

    @Override
    public List<String> getFromOnly() {
        return this.fromOnly;
    }

    @Override
    public boolean isMinor() {
        return this.getFromOnly().isEmpty() && this.getRenamed().isEmpty() && this.getChanged().isEmpty();
    }

    @Override
    public Map<String, String> getRenamed() {
        return this.renamed;
    }

    @Override
    public List<String> getToOnly() {
        return this.toOnly;
    }

    @Override
    public boolean isEmpty() {
        return this.toOnly.isEmpty() && this.fromOnly.isEmpty() && this.changed.isEmpty() && this.renamed.isEmpty();
    }

    MdDelta diff() {
        if (this.mustDiff) {
            this.matchRenames();
            this.findRenames();
            this.mustDiff = false;
        }
        return this;
    }

    int diffWeight(T f, T t) {
        return ((MetadataObject)f).sameAs(t) ? 0 : Integer.MAX_VALUE;
    }

    void findRenames() {
        ArrayList<Tuple3> differences = new ArrayList<Tuple3>();
        for (String fnm : this.fromOnly) {
            T f = this.getFrom(fnm);
            for (String tnm : this.toOnly) {
                T t = this.getTo(tnm);
                int diff = this.diffWeight(f, t);
                if (diff >= this.getDiffThreshold()) continue;
                differences.add(Tuple.tuple((Object)fnm, (Object)tnm, (Object)diff));
            }
        }
        Collections.sort(differences, Comparator.comparingInt(Tuple3::_3));
        for (Tuple3 d : differences) {
            String nameFrom = (String)d._1();
            String nameTo = (String)d._2();
            if (!this.fromOnly.remove(nameFrom) || !this.toOnly.remove(nameTo)) continue;
            this.renamed.put(nameFrom, nameTo);
            if (((MetadataObject)this.getFrom(nameFrom)).sameAs(this.getTo(nameTo))) continue;
            this.changed.add(nameFrom);
        }
    }

    void generateAlter(PrintWriter pw, String name) {
        T e = this.getRenamedTo(name);
        this.generateDrop(pw, ((MetadataObject)e).getName());
        this.generateCreate(pw, e);
    }

    abstract void generateCreate(PrintWriter var1, T var2);

    abstract void generateDrop(PrintWriter var1, String var2);

    void generateRename(PrintWriter pw, String from, String to) {
        this.generateDrop(pw, from);
        this.generateCreate(pw, this.getTo(to));
    }

    int getDiffThreshold() {
        return 1;
    }

    abstract T getFrom(String var1);

    abstract Iterable<T> getFromElements();

    T getRenamedTo(String fromName) {
        return this.getTo((String)Predefined.notNull((Object)this.renamed.get(fromName), (Object)fromName));
    }

    String getSchemaName() {
        return this.schemaName;
    }

    abstract T getTo(String var1);

    abstract Iterable<T> getToElements();

    private void matchRenames() {
        String name;
        for (MetadataObject tf : this.getFromElements()) {
            name = tf.getName();
            T tt = this.getTo(name);
            if (tt == null) {
                this.fromOnly.add(name);
                continue;
            }
            if (tf.sameAs(tt)) continue;
            this.changed.add(name);
        }
        for (MetadataObject tt : this.getToElements()) {
            name = tt.getName();
            if (this.getFrom(name) != null) continue;
            this.toOnly.add(name);
        }
    }
}

