/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect.delta;

import java.io.PrintWriter;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SequenceInfo;
import mulesoft.database.introspect.TableInfo;
import mulesoft.database.introspect.delta.MdDelta;
import mulesoft.database.introspect.delta.MdDiffer;

class SequenceDiffer
extends MdDiffer<SequenceInfo> {
    private final SchemaInfo from;
    private final SchemaInfo to;

    public SequenceDiffer(SchemaInfo from, SchemaInfo to) {
        super(to.getPlainName());
        this.from = from;
        this.to = to;
    }

    @Override
    public void generate(PrintWriter pw) {
        if (this.diff().isEmpty()) {
            return;
        }
        SchemaInfo.generateSequences(pw, () -> SequenceDiffer.super.generate(pw));
    }

    public void generateCreates(PrintWriter pw) {
        if (this.diff().getToOnly().isEmpty()) {
            return;
        }
        SchemaInfo.generateSequences(pw, () -> SequenceDiffer.super.createElements(pw));
    }

    public void generateDrops(PrintWriter pw) {
        if (this.diff().getFromOnly().isEmpty()) {
            return;
        }
        SchemaInfo.generateSequences(pw, () -> SequenceDiffer.super.dropElements(pw));
    }

    @Override
    MdDelta diff() {
        return super.diff();
    }

    @Override
    void generateCreate(PrintWriter pw, SequenceInfo seq) {
        seq.dumpSql(pw);
        pw.println();
    }

    @Override
    void generateDrop(PrintWriter pw, String name) {
        pw.printf("drop   sequence %s /* Ignore Errors */;;%n%n", TableInfo.getQName(this.getSchemaName(), name));
    }

    @Override
    SequenceInfo getFrom(String nm) {
        return this.from.getSequence(nm);
    }

    @Override
    Iterable<SequenceInfo> getFromElements() {
        return this.from.getSequences();
    }

    @Override
    SequenceInfo getTo(String nm) {
        return this.to.getSequence(nm);
    }

    @Override
    Iterable<SequenceInfo> getToElements() {
        return this.to.getSequences();
    }
}

