/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect.delta;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.core.Tuple;
import mulesoft.database.DbMacro;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SqlKind;
import mulesoft.database.introspect.SqlType;
import mulesoft.database.introspect.TableInfo;
import mulesoft.database.introspect.delta.MdDelta;
import mulesoft.database.introspect.delta.MdDiffer;
import mulesoft.database.introspect.delta.TableDeltas;
import org.jetbrains.annotations.Nullable;

class TableDiffer
extends MdDiffer<TableInfo>
implements TableDeltas {
    private final Map<Tuple<String, TableInfo.Element>, MdDelta> differs;
    private final SchemaInfo from;
    private final SchemaInfo to;
    private static final int TABLE_THRESHOLD = 4;

    public TableDiffer(SchemaInfo from, SchemaInfo to) {
        super(to.getPlainName());
        this.from = from;
        this.to = to;
        this.differs = new HashMap<Tuple<String, TableInfo.Element>, MdDelta>();
    }

    @Override
    public MdDelta diff(String tableName, TableInfo.Element element) {
        Tuple key = Tuple.tuple((Object)tableName, (Object)((Object)element));
        return this.differs.computeIfAbsent((Tuple<String, TableInfo.Element>)key, k -> this.hasChanged(tableName) ? this.createDiffer(tableName, element).diff() : MdDelta.EMPTY);
    }

    @Override
    public void generate(PrintWriter pw) {
        this.diff();
        for (String name : this.getFromOnly()) {
            this.getFrom(name).dropForeignKeys(pw);
        }
        for (String name : this.getChanged()) {
            this.diff(name, TableInfo.Element.FOREIGN_KEY).dropElements(pw);
        }
        super.generate(pw);
        for (String name : this.getChanged()) {
            this.diff(name, TableInfo.Element.FOREIGN_KEY).createElements(pw);
        }
        for (String name : this.getToOnly()) {
            this.getTo(name).dumpForeignKeys(pw);
        }
    }

    @Override
    public boolean primaryKeyChange(String name) {
        return !this.getFrom(name).getPrimaryKey().sameAs(((TableInfo)this.getRenamedTo(name)).getPrimaryKey());
    }

    @Override
    public boolean isMinor() {
        if (!this.getFromOnly().isEmpty() || !this.getRenamed().isEmpty()) {
            return false;
        }
        for (String name : this.getChanged()) {
            for (TableInfo.Element element : TableInfo.Element.values()) {
                if (this.diff(name, element).isMinor()) continue;
                return false;
            }
            if (!this.primaryKeyChange(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    TableDeltas diff() {
        return (TableDeltas)super.diff();
    }

    @Override
    int diffWeight(TableInfo a, TableInfo b) {
        int diff = 0;
        for (TableInfo.Column ac : a.getColumns()) {
            TableInfo.Column bc = b.getColumn(ac.getName());
            if (bc != null && ac.getType().equals(bc.getType())) continue;
            ++diff;
        }
        for (TableInfo.Column bc : b.getColumns()) {
            if (a.getColumn(bc.getName()) != null) continue;
            ++diff;
        }
        return diff;
    }

    @Override
    void generateAlter(PrintWriter pw, String name) {
        this.generatePrimaryDropKeyChanges(pw, name);
        this.diff(name, TableInfo.Element.COLUMN).generate(pw);
        this.diff(name, TableInfo.Element.CHECK).generate(pw);
        this.diff(name, TableInfo.Element.INDEX).generate(pw);
        this.diff(name, TableInfo.Element.UNIQUE).generate(pw);
        this.generatePrimaryKeyAddChanges(pw, name);
    }

    void generateAlterTable(PrintWriter pw, String name) {
        TableInfo.generateAlterTable(pw, name, this.getSchemaName());
    }

    @Override
    void generateCreate(PrintWriter pw, TableInfo table) {
        table.dumpSql(pw, false);
        pw.println();
        table.dumpTableIndices(pw);
    }

    @Override
    void generateDrop(PrintWriter pw, String name) {
        pw.printf("drop   table %s;;%n%n", this.getQName(name));
    }

    @Override
    void generateRename(PrintWriter pw, String tableFrom, String tableTo) {
        this.generateAlterTable(pw, tableFrom);
        pw.printf("rename to %s;;%n%n", tableTo);
    }

    @Override
    int getDiffThreshold() {
        return 4;
    }

    @Override
    @Nullable
    TableInfo getFrom(String nm) {
        return (TableInfo)this.from.getTable(nm).getOrNull();
    }

    @Override
    Iterable<TableInfo> getFromElements() {
        return this.from.getTables();
    }

    @Override
    @Nullable
    TableInfo getTo(String nm) {
        return (TableInfo)this.to.getTable(nm).getOrNull();
    }

    @Override
    Iterable<TableInfo> getToElements() {
        return this.to.getTables();
    }

    private MdDiffer<?> createDiffer(String tableName, TableInfo.Element element) {
        switch (element) {
            case CHECK: {
                return new CheckDiffer(tableName);
            }
            case INDEX: {
                return new IndexDiffer(tableName);
            }
            case COLUMN: {
                return new ColumnDiffer(tableName);
            }
            case FOREIGN_KEY: {
                return new ForeignKeyDiffer(tableName);
            }
            case UNIQUE: {
                return new UniqueDiffer(tableName);
            }
        }
        throw Predefined.unreachable();
    }

    private void generatePrimaryDropKeyChanges(PrintWriter pw, String name) {
        if (this.primaryKeyChange(name)) {
            TableInfo tt = (TableInfo)this.getRenamedTo(name);
            String toName = tt.getName();
            this.generateAlterTable(pw, toName);
            TableInfo.dropConstraint(pw, this.getFrom(name).getPrimaryKey().getName());
        }
    }

    private void generatePrimaryKeyAddChanges(PrintWriter pw, String name) {
        if (this.primaryKeyChange(name)) {
            TableInfo tt = (TableInfo)this.getRenamedTo(name);
            String toName = tt.getName();
            this.generateAlterTable(pw, toName);
            pw.printf("add %s;;%n%n", tt.getPrimaryKey().generateSql());
        }
    }

    private boolean hasChanged(String name) {
        return this.getChanged().contains(name);
    }

    private String getQName(String name) {
        return TableInfo.getQName(this.getSchemaName(), name);
    }

    private static String normalizeDefault(@Nullable String v) {
        if (v == null) {
            return "null";
        }
        switch (v.toLowerCase()) {
            case "''": {
                return DbMacro.EmptyString.name();
            }
            case "current_date": {
                return DbMacro.CurrentDate.name();
            }
            case "current_timestamp": {
                return DbMacro.CurrentTime.name();
            }
            case "false": {
                return DbMacro.False.name();
            }
            case "true": {
                return DbMacro.True.name();
            }
        }
        return v;
    }

    private class UniqueDiffer
    extends ElementDiffer<TableInfo.Index> {
        public UniqueDiffer(String tableName) {
            super(tableName, TableInfo.Element.UNIQUE);
        }

        @Override
        void generateCreate(PrintWriter pw, TableInfo.Index unique) {
            TableDiffer.this.generateAlterTable(pw, this.getTableName());
            pw.printf("add %s;;%n%n", unique.generateUniqueSql());
        }

        @Override
        void generateDrop(PrintWriter pw, String name) {
            TableDiffer.this.generateAlterTable(pw, this.getTableName());
            TableInfo.dropConstraint(pw, name);
        }
    }

    private class IndexDiffer
    extends ElementDiffer<TableInfo.Index> {
        public IndexDiffer(String tableName) {
            super(tableName, TableInfo.Element.INDEX);
        }

        @Override
        void generateCreate(PrintWriter pw, TableInfo.Index index) {
            index.dumpSql(pw);
        }

        @Override
        void generateDrop(PrintWriter pw, String name) {
            pw.printf("drop   index IndexName(%s, %s);;%n%n", this.getSchemaName(), name);
        }

        @Override
        void generateRename(PrintWriter pw, String fi, String ti) {
            pw.printf("alter  index IndexName(%s, %s)%n\trename to %s;;%n%n", this.getSchemaName(), fi, ti);
        }
    }

    private class ForeignKeyDiffer
    extends ElementDiffer<TableInfo.ForeignKey> {
        public ForeignKeyDiffer(String tableName) {
            super(tableName, TableInfo.Element.FOREIGN_KEY);
        }

        @Override
        public void createElements(PrintWriter pw) {
            super.createElements(pw);
            for (String name : this.getChanged()) {
                this.generateCreate(pw, (TableInfo.ForeignKey)this.getTo(name));
            }
        }

        @Override
        public void dropElements(PrintWriter pw) {
            super.dropElements(pw);
            for (String name : this.getChanged()) {
                this.generateDrop(pw, name);
            }
        }

        @Override
        void generateCreate(PrintWriter pw, TableInfo.ForeignKey fk) {
            fk.dumpSql(pw);
        }

        @Override
        void generateDrop(PrintWriter pw, String name) {
            TableDiffer.this.generateAlterTable(pw, this.getTableName());
            TableInfo.dropConstraint(pw, name);
        }
    }

    abstract class ElementDiffer<T extends TableInfo.TableObject<T>>
    extends MdDiffer<T> {
        private final TableInfo.Element element;
        private final TableInfo tf;
        private final TableInfo tt;

        ElementDiffer(String name, TableInfo.Element element) {
            this(element, this$0.getFrom(name), (TableInfo)this$0.getRenamedTo(name));
        }

        private ElementDiffer(TableInfo.Element element, TableInfo tf, TableInfo tt) {
            super(tt.getSchema().getPlainName());
            this.tf = tf;
            this.tt = tt;
            this.element = element;
        }

        @Override
        T getFrom(String nm) {
            return (T)((TableInfo.TableObject)Predefined.cast(this.tf.getElement(nm, this.element)));
        }

        @Override
        Iterable<T> getFromElements() {
            return this.tf.getElements(this.element);
        }

        String getTableName() {
            return this.tt.getName();
        }

        @Override
        T getTo(String nm) {
            return (T)((TableInfo.TableObject)Predefined.cast(this.tt.getElement(nm, this.element)));
        }

        @Override
        Iterable<T> getToElements() {
            return this.tt.getElements(this.element);
        }
    }

    class ColumnDiffer
    extends ElementDiffer<TableInfo.Column> {
        private static final int COLUMN_THRESHOLD = 3;

        ColumnDiffer(String tableName) {
            super(tableName, TableInfo.Element.COLUMN);
        }

        @Override
        public boolean isMinor() {
            if (!this.getFromOnly().isEmpty() || !this.getRenamed().isEmpty()) {
                return false;
            }
            for (String name : this.getChanged()) {
                TableInfo.Column t;
                TableInfo.Column f = (TableInfo.Column)super.getFrom(name);
                if (this.majorTypeChange(f, t = (TableInfo.Column)this.getRenamedTo(name))) {
                    return false;
                }
                if (!f.isOptional() || t.isOptional() || t.getDefaultValue() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        int diffWeight(TableInfo.Column f, TableInfo.Column t) {
            int diff = 0;
            SqlType fType = f.getType();
            SqlType tType = t.getType();
            if (fType.getSqlKind() != tType.getSqlKind()) {
                diff += 10;
            }
            if (f.isSerial() != t.isSerial()) {
                diff += 10;
            }
            if (fType.getPrecision() != tType.getPrecision()) {
                ++diff;
            }
            if (fType.getSize() != tType.getSize()) {
                ++diff;
            }
            if (f.isOptional() != t.isOptional()) {
                ++diff;
            }
            if (!Predefined.equal((Object)f.getDefaultValue(), (Object)t.getDefaultValue())) {
                ++diff;
            }
            return diff;
        }

        @Override
        void generateAlter(PrintWriter pw, String name) {
            TableInfo.Column cf = (TableInfo.Column)super.getFrom(name);
            TableInfo.Column ct = (TableInfo.Column)this.getRenamedTo(name);
            if (!cf.getType().sameAs(ct.getType())) {
                this.alterTable(pw).printf("%s(%s, %s);;%n%n", DbMacro.AlterColumnType, ct.getName(), ct.formatType());
                if (cf.getType().getSqlKind() == SqlKind.BOOLEAN) {
                    String constraintName = TableInfo.getConstrainedName(cf.getTable().getName() + "_" + cf.getName(), "B");
                    TableInfo.dropConstraint(pw, constraintName);
                }
            }
            if (!Predefined.equal((Object)cf.getDefaultValue(), (Object)ct.getDefaultValue())) {
                this.alterTable(pw).printf("%s(%s, %s);;%n%n", DbMacro.SetDefault, ct.getName(), TableDiffer.normalizeDefault(ct.getDefaultValue()));
            }
            if (cf.isOptional() != ct.isOptional()) {
                this.alterTable(pw).printf("%s(%s);;%n%n", ct.isOptional() ? DbMacro.DropNotNull : DbMacro.SetNotNull, ct.getName());
            }
        }

        @Override
        void generateCreate(PrintWriter pw, TableInfo.Column element) {
            this.alterTable(pw).printf("AddColumn(%s);;%n%n", element);
        }

        @Override
        void generateDrop(PrintWriter pw, String name) {
            this.alterTable(pw).printf("drop column %s;;%n%n", name);
        }

        @Override
        void generateRename(PrintWriter pw, String cf, String ct) {
            this.alterTable(pw).printf("%s(%s, %s);;%n%n", DbMacro.RenameColumn, cf, ct);
        }

        @Override
        int getDiffThreshold() {
            return 3;
        }

        private PrintWriter alterTable(PrintWriter pw) {
            TableDiffer.this.generateAlterTable(pw, this.getTableName());
            return pw;
        }

        private boolean majorTypeChange(TableInfo.Column f, TableInfo.Column t) {
            SqlType fType = f.getType();
            SqlType tType = t.getType();
            return fType.getSqlKind() != tType.getSqlKind() || fType.getPrecision() > tType.getPrecision() || fType.getSize() > tType.getSize();
        }
    }

    private class CheckDiffer
    extends ElementDiffer<TableInfo.Check> {
        public CheckDiffer(String tableName) {
            super(tableName, TableInfo.Element.CHECK);
        }

        @Override
        void generateAlter(PrintWriter pw, String name) {
        }

        @Override
        void generateCreate(PrintWriter pw, TableInfo.Check element) {
        }

        @Override
        void generateDrop(PrintWriter pw, String name) {
        }

        @Override
        void generateRename(PrintWriter pw, String fc, String tc) {
        }
    }
}

