/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect.delta;

import java.io.PrintWriter;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.TableInfo;
import mulesoft.database.introspect.ViewInfo;
import mulesoft.database.introspect.delta.MdDelta;
import mulesoft.database.introspect.delta.MdDiffer;
import org.jetbrains.annotations.Nullable;

class ViewsDiffer
extends MdDiffer<ViewInfo> {
    private final SchemaInfo from;
    private final SchemaInfo to;

    public ViewsDiffer(SchemaInfo from, SchemaInfo to) {
        super(to.getPlainName());
        this.from = from;
        this.to = to;
    }

    @Override
    public void generate(PrintWriter pw) {
        if (this.diff().isEmpty()) {
            return;
        }
        for (String name : this.getFromOnly()) {
            this.generateDrop(pw, name);
        }
        for (String name : this.getChanged()) {
            this.generateAlter(pw, this.getTo(name));
        }
        for (String name : this.getToOnly()) {
            this.generateCreate(pw, this.getTo(name));
        }
    }

    @Override
    public boolean isMinor() {
        return true;
    }

    @Override
    MdDelta diff() {
        return super.diff();
    }

    void generateAlter(PrintWriter pw, ViewInfo view) {
        view.dumpSql(pw, false);
        pw.println();
    }

    @Override
    void generateCreate(PrintWriter pw, ViewInfo view) {
        view.dumpSql(pw, true);
        pw.println();
    }

    @Override
    void generateDrop(PrintWriter pw, String name) {
        pw.printf("drop view %s;;", TableInfo.getQName(this.getSchemaName(), name));
        pw.println();
    }

    @Override
    @Nullable
    ViewInfo getFrom(String nm) {
        return (ViewInfo)this.from.getView(nm).getOrNull();
    }

    @Override
    Iterable<ViewInfo> getFromElements() {
        return this.from.getViews();
    }

    @Override
    @Nullable
    ViewInfo getTo(String nm) {
        return (ViewInfo)this.to.getView(nm).getOrNull();
    }

    @Override
    Iterable<ViewInfo> getToElements() {
        return this.to.getViews();
    }
}

