/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ion.client;

import com.mulesoft.ion.client.Application;
import com.mulesoft.ion.client.ApplicationStatusChange;
import com.mulesoft.ion.client.Connection;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class DomainConnection
extends Connection {
    public static final String DEFAULT_MULE_VERSION = "3.2.1";
    public static final int DEFAULT_WORKERS = 1;
    public static final long DEFAULT_MAX_WAIT_TIME = 120000L;
    private final String domain;

    public DomainConnection(Connection connection, String domain) {
        super(connection.getUrl(), connection.getUsername(), connection.getPassword());
        if (domain == null) {
            throw new IllegalArgumentException("null domain");
        }
        this.domain = domain;
    }

    public final String getDomain() {
        return this.domain;
    }

    protected final Application getIONApplication() {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder(this.getDomain()).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        this.handleErrors(response);
        return (Application)response.getEntity(Application.class);
    }

    protected final boolean isIONApplicationCreated(String domain) {
        try {
            this.getIONApplication();
            return true;
        }
        catch (UniformInterfaceException e) {
            return false;
        }
    }

    protected final void ensureIONApplicationExists(String domain) {
        if (!this.isIONApplicationCreated(domain)) {
            throw new RuntimeException("iON Application <" + domain + "> does not exit on <" + this.getUrl() + ">");
        }
    }

    public final void update(Application application) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder(this.domain).type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)application);
        this.handleErrors(response);
    }

    public final void deploy(File file) {
        this.deploy(file, DEFAULT_MULE_VERSION, 1, 120000L, Collections.EMPTY_MAP);
    }

    public final void deploy(File file, String muleVersion, int workers, long maxWaitTime, Map<String, String> properties) {
        this.ensureIONApplicationExists(this.getDomain());
        Application application = this.getIONApplication();
        if (!application.getSupportedVersions().contains(muleVersion)) {
            throw new IllegalArgumentException("Requested mule version <" + muleVersion + "> is not one of supported versions <" + application.getSupportedVersions() + ">");
        }
        if (workers > application.getRemainingWorkerCount()) {
            throw new IllegalArgumentException("Requested <" + workers + "> workers but only <" + application.getRemainingWorkerCount() + "> are remaining");
        }
        switch (application.getStatus()) {
            case STARTED: 
            case UNDEPLOYED: 
            case DEPLOY_FAILED: {
                boolean updated = false;
                if (workers != application.getWorkers()) {
                    application.setWorkers(workers);
                    updated = true;
                }
                if (!muleVersion.equals(application.getMuleVersion())) {
                    application.setMuleVersion(muleVersion);
                    updated = true;
                }
                if (!file.getName().equals(application.getFilename())) {
                    application.setFilename(file.getName());
                    updated = true;
                }
                if (properties != null && !((Object)properties).equals(application.getProperties())) {
                    application.setProperties(properties);
                    updated = true;
                }
                if (updated) {
                    this.update(application);
                }
                ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder(this.getDomain() + "/deploy").type(MediaType.APPLICATION_OCTET_STREAM_TYPE)).post(ClientResponse.class, (Object)file);
                this.handleErrors(response);
                break;
            }
            case DEPLOYING: {
                throw new IllegalStateException("Another deployment is in progress");
            }
            default: {
                throw new IllegalStateException("Unhandled status <" + (Object)((Object)application.getStatus()) + ">");
            }
        }
        this.waitForStart(maxWaitTime);
    }

    private void waitForStart(long maxWaitTime) {
        if (maxWaitTime == 0L) {
            return;
        }
        long before = System.currentTimeMillis();
        while (System.currentTimeMillis() - before < maxWaitTime) {
            Application latestApplication = this.getIONApplication();
            Application.Status status = latestApplication.getDeploymentUpdateStatus() != null ? latestApplication.getDeploymentUpdateStatus() : latestApplication.getStatus();
            switch (status) {
                case DEPLOY_FAILED: {
                    throw new RuntimeException("Application " + this.domain + " failed to start.");
                }
                case STARTED: {
                    return;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new RuntimeException("Waited on <" + this.getDomain() + "> deployment for <" + maxWaitTime + "> ms");
    }

    public final void stop() {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder("status/").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)new ApplicationStatusChange(ApplicationStatusChange.ApplicationStatus.stop));
        this.handleErrors(response);
    }

    public final void start(Long maxWaitTime) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder("status/").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)new ApplicationStatusChange(ApplicationStatusChange.ApplicationStatus.start));
        this.handleErrors(response);
        this.waitForStart(maxWaitTime);
    }

    public void delete() {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class);
        this.handleErrors(response);
    }

    protected final WebResource.Builder createApplicationBuilder(String path) {
        return this.createBuilder("applications/" + this.domain + "/" + path);
    }

    public Application get() {
        ClientResponse response = (ClientResponse)this.createApplicationBuilder("").get(ClientResponse.class);
        this.handleErrors(response);
        return (Application)response.getEntity(Application.class);
    }
}

