/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.provider.aws.secrets.manager.configuration.properties.api;

import com.mulesoft.provider.aws.secrets.manager.configuration.properties.api.AWSSecretsManagerConfigurationPropertiesConstants;
import com.mulesoft.provider.aws.secrets.manager.configuration.properties.internal.error.exception.AwsAssumeRoleException;
import com.mulesoft.provider.aws.secrets.manager.configuration.properties.internal.provider.AWSSecretsManagerConfigurationPropertiesProvider;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.StsException;

public class AWSSecretsManagerConfigurationPropertiesProviderFactory
implements ConfigurationPropertiesProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AWSSecretsManagerConfigurationPropertiesProviderFactory.class);
    private final ResourceBundle logProvider = ResourceBundle.getBundle("messages");
    private final ComponentIdentifier PropertiesProviderIdentifier = ComponentIdentifier.builder().namespace(AWSSecretsManagerConfigurationPropertiesConstants.EXTENSION_NAMESPACE).name("config").build();

    public ComponentIdentifier getSupportedComponentIdentifier() {
        return this.PropertiesProviderIdentifier;
    }

    public ConfigurationPropertiesProvider createProvider(ConfigurationParameters parameters, ResourceProvider externalResourceProvider) {
        List basicConnectionsList = parameters.getComplexConfigurationParameter(ComponentIdentifier.builder().namespace(AWSSecretsManagerConfigurationPropertiesConstants.EXTENSION_NAMESPACE).name(AWSSecretsManagerConfigurationPropertiesConstants.AWS_BASIC_CONNECTION_PARAMETER_GROUP_NAME).build());
        ConfigurationParameters basicConnectionParams = (ConfigurationParameters)basicConnectionsList.get(0);
        List roleConnectionsList = parameters.getComplexConfigurationParameter(ComponentIdentifier.builder().namespace(AWSSecretsManagerConfigurationPropertiesConstants.EXTENSION_NAMESPACE).name(AWSSecretsManagerConfigurationPropertiesConstants.AWS_ROLE_CONNECTION_PARAMETER_GROUP_NAME).build());
        ConfigurationParameters roleConnectionParams = roleConnectionsList.isEmpty() ? null : (ConfigurationParameters)roleConnectionsList.get(0);
        String region = basicConnectionParams.getStringParameter("region").toLowerCase();
        String accessKey = basicConnectionParams.getStringParameter("accessKey");
        String secretKey = basicConnectionParams.getStringParameter("secretKey");
        String roleARN = null;
        String externalId = null;
        if (Objects.nonNull(roleConnectionParams)) {
            roleARN = roleConnectionParams.getStringParameter("roleARN");
            externalId = roleConnectionParams.getStringParameter("externalId");
        }
        if (StringUtils.isBlank((CharSequence)accessKey) || StringUtils.isBlank((CharSequence)secretKey)) {
            LOGGER.info(this.logProvider.getString("info.default.chain.credentials"));
        } else {
            LOGGER.info(this.logProvider.getString("info.basic.credentials"));
            LOGGER.warn(this.logProvider.getString("warn.basic.credential"));
        }
        return new AWSSecretsManagerConfigurationPropertiesProvider(this.createAWSSecretsManager(region, accessKey, secretKey, roleARN, externalId));
    }

    private SecretsManagerClient createAWSSecretsManager(String region, String accessKey, String secretKey, String roleARN, String externalId) {
        AwsCredentialsProvider awsCredentialsProvider = this.getAWSCredentialsProvider(region, accessKey, secretKey, roleARN, externalId);
        return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)region))).credentialsProvider(awsCredentialsProvider)).build();
    }

    private AwsCredentialsProvider getAWSCredentialsProvider(String region, String accessKey, String secretKey, String roleARN, String externalId) {
        DefaultCredentialsProvider awsCredentialsProvider = null;
        if (StringUtils.isBlank((CharSequence)accessKey) || StringUtils.isBlank((CharSequence)secretKey)) {
            LOGGER.debug(this.logProvider.getString("debug.creating.default.credentials"));
            awsCredentialsProvider = DefaultCredentialsProvider.create();
        } else {
            LOGGER.debug(this.logProvider.getString("debug.creating.basic.credentials"));
            AwsBasicCredentials awsCredentials = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            awsCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        }
        if (StringUtils.isNotEmpty((CharSequence)roleARN)) {
            return this.getAssumeRoleCredentials(roleARN, externalId, region, (AwsCredentialsProvider)awsCredentialsProvider);
        }
        return awsCredentialsProvider;
    }

    private AwsCredentialsProvider getAssumeRoleCredentials(String roleARN, String externalId, String region, AwsCredentialsProvider awsCredentialsProvider) {
        LOGGER.info(this.logProvider.getString("info.role.arn.provided"), (Object)roleARN);
        StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(awsCredentialsProvider)).region(Region.of((String)region))).build();
        try {
            AssumeRoleRequest.Builder roleRequestBuilder = AssumeRoleRequest.builder().roleArn(roleARN).roleSessionName("WithRoleARN");
            if (StringUtils.isNotEmpty((CharSequence)externalId)) {
                LOGGER.info("Using external ID for role assumption");
                roleRequestBuilder.externalId(externalId);
            }
            AssumeRoleRequest roleRequest = (AssumeRoleRequest)roleRequestBuilder.build();
            AssumeRoleResponse roleResponse = stsClient.assumeRole(roleRequest);
            Credentials roleCredentials = roleResponse.credentials();
            Instant expiration = roleCredentials.expiration();
            String sessionToken = roleCredentials.sessionToken();
            String accessKey = roleCredentials.accessKeyId();
            String secretKey = roleCredentials.secretAccessKey();
            LOGGER.info(this.logProvider.getString("info.role.arn.being.created"), (Object)expiration.toString());
            AwsSessionCredentials awsCredentials = AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken);
            LOGGER.info(this.logProvider.getString("info.role.arn.created"), (Object)roleARN);
            return StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        }
        catch (StsException e) {
            String errMsg = e.getMessage();
            throw new AwsAssumeRoleException(errMsg, e);
        }
    }
}

