/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.provider.aws.secrets.manager.configuration.properties.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;
import org.mule.sdk.api.meta.JavaVersion;

public class AWSSecretsManagerPropertiesExtensionLoadingDelegate
implements ExtensionLoadingDelegate {
    public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext context) {
        Optional<Method> supportingJavaVersionsMethod = Arrays.stream(extensionDeclarer.getClass().getMethods()).filter(method -> method.getName().equals("supportingJavaVersions")).filter(method -> Arrays.equals(method.getParameterTypes(), new Class[]{Set.class})).findFirst();
        if (supportingJavaVersionsMethod.isPresent()) {
            try {
                extensionDeclarer = (ExtensionDeclarer)supportingJavaVersionsMethod.get().invoke((Object)extensionDeclarer, new LinkedHashSet<String>(Arrays.asList(JavaVersion.JAVA_8.version(), JavaVersion.JAVA_11.version(), JavaVersion.JAVA_17.version())));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to initialize the extension when trying to declare `supportingJavaVersions` for the extension.", e);
            }
        }
        extensionDeclarer.named("AWS Secrets Manager Properties Override");
        extensionDeclarer.describedAs(String.format("%s Extension", "AWS Secrets Manager Properties Override"));
        extensionDeclarer.withCategory(Category.SELECT);
        extensionDeclarer.onVersion("1.0.0");
        extensionDeclarer.fromVendor("AWS");
        ConfigurationDeclarer configurationDeclarer = extensionDeclarer.withConfig("config");
        this.addSecretsManagerParameters(configurationDeclarer);
    }

    private void addSecretsManagerParameters(ConfigurationDeclarer configurationDeclarer) {
        ParameterGroupDeclarer addBasicConnectionParametersGroup = configurationDeclarer.onParameterGroup("Basic Connection").withDslInlineRepresentation(true);
        ParameterGroupDeclarer addRoleConnectionParametersGroup = configurationDeclarer.onParameterGroup("Role Connection").withDslInlineRepresentation(true);
        addBasicConnectionParametersGroup.withRequiredParameter("region").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build()).withExpressionSupport(ExpressionSupport.SUPPORTED).withDisplayModel(DisplayModel.builder().displayName("AWS Secrets Manager Region").build()).describedAs("AWS Secrets Manager region as us-east-2");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)addBasicConnectionParametersGroup.withOptionalParameter("accessKey").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build())).withExpressionSupport(ExpressionSupport.SUPPORTED)).withDisplayModel(DisplayModel.builder().displayName("AWS Access Key").build())).describedAs("AWS Access Key");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)addBasicConnectionParametersGroup.withOptionalParameter("secretKey").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build())).withExpressionSupport(ExpressionSupport.SUPPORTED)).withDisplayModel(DisplayModel.builder().displayName("AWS Secret Key").build())).describedAs("AWS Secret Key");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)addRoleConnectionParametersGroup.withOptionalParameter("roleARN").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build())).withExpressionSupport(ExpressionSupport.SUPPORTED)).withDisplayModel(DisplayModel.builder().displayName("Role ARN").build())).describedAs("The Role ARN unique identifies role to assume in order to gain cross account access.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)addRoleConnectionParametersGroup.withOptionalParameter("externalId").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build())).withExpressionSupport(ExpressionSupport.SUPPORTED)).withDisplayModel(DisplayModel.builder().displayName("External ID").build())).describedAs("The External ID is used to prevent the confused deputy problem when assuming a role in another account.");
    }
}

