/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.provider.aws.secrets.manager.configuration.properties.internal.provider;

import com.mulesoft.provider.aws.secrets.manager.configuration.properties.internal.error.exception.AwsAuthenticationException;
import com.mulesoft.provider.aws.secrets.manager.configuration.properties.internal.error.exception.AwsSecretNotFoundException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

public class AWSSecretsManagerConfigurationPropertiesProvider
implements ConfigurationPropertiesProvider {
    private final SecretsManagerClient secretsManagerClient;
    private final ResourceBundle logProvider = ResourceBundle.getBundle("messages");

    public AWSSecretsManagerConfigurationPropertiesProvider(SecretsManagerClient secretsManagerClient) {
        this.secretsManagerClient = secretsManagerClient;
    }

    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        String effectiveKey;
        String value;
        if (configurationAttributeKey.startsWith("aws-secrets::") && StringUtils.isNotBlank((CharSequence)(value = this.getSecret(effectiveKey = this.getSecretName(configurationAttributeKey))))) {
            return Optional.of(new ConfigurationProperty(){

                public Object getSource() {
                    return "AWS Secrets Manager";
                }

                public Object getRawValue() {
                    return value;
                }

                public String getKey() {
                    return effectiveKey;
                }
            });
        }
        return Optional.empty();
    }

    public String getDescription() {
        return this.logProvider.getString("message.description");
    }

    private String getSecret(String secretKey) {
        GetSecretValueResponse valueResponse;
        try {
            GetSecretValueRequest valueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretKey).versionStage("AWSCURRENT").build();
            valueResponse = this.secretsManagerClient.getSecretValue(valueRequest);
        }
        catch (ResourceNotFoundException e) {
            throw new AwsSecretNotFoundException(this.logProvider.getString("error.aws.sm"), e);
        }
        catch (SecretsManagerException e) {
            throw new AwsAuthenticationException(this.logProvider.getString("error.connection"), e);
        }
        catch (Exception e) {
            throw e;
        }
        String secret = null;
        secret = valueResponse.secretString() != null ? valueResponse.secretString() : new String(Base64.getDecoder().decode(valueResponse.secretBinary().asByteBuffer()).array());
        return secret;
    }

    private String getSecretName(String configurationAttributeKey) {
        if (!configurationAttributeKey.contains("::")) {
            throw new IllegalArgumentException(this.logProvider.getString("error.key.format"));
        }
        List<String> keys = Arrays.asList(configurationAttributeKey.substring("aws-secrets::".length()).split("::"));
        return keys.get(0);
    }
}

