/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.conductor.api.model.a2a;

import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;

/**
 * Represents an A2A client configuration for the Agent Conductor. This class extends the base Tool class and adds A2A-specific
 * configuration.
 */
@Alias("a2aClient")
public class A2AClient {

  @ConfigReference(namespace = "A2_A", name = "CLIENT")
  @Parameter
  private String a2aClientConfigRef;

  public String getA2AClientConfigRef() {
    return a2aClientConfigRef;
  }

}
