/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */

package com.mulesoft.modules.agent.conductor.internal.state.model;

import java.io.Serializable;

public class ConversationState implements Serializable {

  private AdditionalInputRequired additionalInputRequired;
  private boolean completed = false;
  private boolean failed = false;
  private String errorMessage;

  public ConversationState() {}

  public ConversationState(boolean completed, boolean failed, String errorMessage) {
    this.completed = completed;
    this.failed = failed;
    this.errorMessage = errorMessage;
  }

  public boolean isCompleted() {
    return completed;
  }

  public boolean getFailed() {
    return failed;
  }

  public void setCompleted(boolean completed) {
    this.completed = completed;
  }

  public void setFailed(boolean failed) {
    this.failed = failed;
  }

  public AdditionalInputRequired getAdditionalInputRequired() {
    return additionalInputRequired;
  }

  public void setAdditionalInputRequired(AdditionalInputRequired additionalInputRequired) {
    this.additionalInputRequired = additionalInputRequired;
  }

  public boolean isFailed() {
    return failed;
  }

  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }
}
