/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */

package com.mulesoft.modules.agent.conductor.internal.state.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TaskContext implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;
  private String contextId;
  private String taskId;
  private int currentIteration = 0;
  private List<Iteration> iterations = new ArrayList<>();
  private ConversationState conversationState = new ConversationState();
  private String conversationHistory = "";
  private Map<String, AgentToolContext> agentToolContexts = new ConcurrentHashMap<>();

  public TaskContext(String id, String taskId, String contextId) {
    this.id = id;
    this.taskId = taskId;
    this.contextId = contextId;
  }

  public void reset() {
    conversationHistory = "";
    iterations.clear();
    conversationState = new ConversationState();
  }

  public String getId() {
    return id;
  }

  public String getContextId() {
    return contextId;
  }

  public String getTaskId() {
    return taskId;
  }

  public int getCurrentIteration() {
    return currentIteration;
  }

  public AgentToolContext getAgentToolContext(String toolName) {
    return agentToolContexts.computeIfAbsent(toolName, t -> new AgentToolContext());
  }

  public void addIteration(Iteration iteration) {
    this.iterations.add(iteration);
  }

  public Iteration getLastIteration() {
    if (iterations.isEmpty()) {
      Iteration iteration = new Iteration();
      addIteration(iteration);

      return iteration;
    } else {
      return iterations.get(iterations.size() - 1);
    }
  }

  public List<Iteration> getIterations() {
    return iterations;
  }

  public ConversationState getConversationState() {
    return conversationState;
  }

  public String getConversationHistory() {
    return conversationHistory;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public void setCurrentIteration(int currentIteration) {
    this.currentIteration = currentIteration;
  }

  public void setIterations(List<Iteration> iterations) {
    this.iterations = iterations;
  }

  public void setCurrentState(ConversationState conversationState) {
    this.conversationState = conversationState;
  }

  public void setConversationHistory(String conversationHistory) {
    this.conversationHistory = conversationHistory;
  }
}
