/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.conductor.internal.tool;

import org.mule.runtime.core.api.util.func.CheckedFunction;

import com.mulesoft.modules.agent.conductor.api.model.tool.Tool;

import java.util.concurrent.CompletableFuture;

public class ToolHandler extends Tool {

  private final CheckedFunction<ToolRequest, CompletableFuture<ToolResponse>> handler;
  private final ToolType toolType;

  public ToolHandler(String name,
                     String description,
                     String input,
                     String output,
                     ToolType toolType,
                     CheckedFunction<ToolRequest, CompletableFuture<ToolResponse>> handler) {
    super(name, description, input, output);
    this.handler = handler;
    this.toolType = toolType;
  }

  public CheckedFunction<ToolRequest, CompletableFuture<ToolResponse>> getHandler() {
    return handler;
  }

  public ToolType getToolType() {
    return toolType;
  }
}
