/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.conductor.internal.tool.a2a;

import static com.mulesoft.modules.agent.conductor.internal.tool.ToolType.A2A;

import com.mulesoft.modules.agent.conductor.internal.tool.ToolType;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolResponse;

public class A2AToolResponse extends ToolResponse {

  private static final String INPUT_REQUIRED = "input-required";

  private String taskId;
  private String contextId;
  private String status;

  public boolean isInputRequired() {
    return INPUT_REQUIRED.equals(status);
  }

  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getContextId() {
    return contextId;
  }

  public void setContextId(String contextId) {
    this.contextId = contextId;
  }

  @Override
  public ToolType getToolType() {
    return A2A;
  }
}
