/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.conductor.internal.tool.a2a;

/**
 * POJO class representing agent summary data for caching. Contains only the essential fields needed for tool handler creation.
 */
public class AgentSummary {

  private String name;
  private String description;
  private String inputDescription;
  private String outputDescription;

  // Default constructor
  public AgentSummary() {}

  // Constructor with all fields
  public AgentSummary(String name, String description, String inputDescription, String outputDescription) {
    this.name = name;
    this.description = description;
    this.inputDescription = inputDescription;
    this.outputDescription = outputDescription;
  }

  // Getters and Setters
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getInputDescription() {
    return inputDescription;
  }

  public void setInputDescription(String inputDescription) {
    this.inputDescription = inputDescription;
  }

  public String getOutputDescription() {
    return outputDescription;
  }

  public void setOutputDescription(String outputDescription) {
    this.outputDescription = outputDescription;
  }

  @Override
  public String toString() {
    return "AgentSummary{" +
        "name='" + name + '\'' +
        ", description='" + description + '\'' +
        ", inputDescription='" + inputDescription + '\'' +
        ", outputDescription='" + outputDescription + '\'' +
        '}';
  }
}
