/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.conductor.internal.llm.client.einstein;

import com.mulesoft.modules.agent.conductor.api.model.llm.einstein.EinsteinModel;
import com.mulesoft.modules.agent.conductor.internal.llm.LLMOrchestrationRequest;
import com.mulesoft.modules.agent.conductor.internal.llm.client.LLMClient;
import com.mulesoft.modules.agent.conductor.internal.serializer.LLMSerializer;
import com.mulesoft.modules.agent.conductor.internal.state.model.LLMOutput;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameterizer;

public class EinsteinClient
implements LLMClient {
    private static final String EXTENSION_NAME = "Einstein AI";
    private static final String SETTINGS_PARAM_GROUP = "Additional properties";
    private final String configRef;
    private final EinsteinModel model;
    private final ExtensionsClient extensionsClient;
    private final LLMSerializer serializer;

    public EinsteinClient(String configRef, EinsteinModel model, ExtensionsClient extensionsClient, LLMSerializer serializer) {
        this.extensionsClient = extensionsClient;
        this.configRef = configRef;
        this.model = model;
        this.serializer = serializer;
    }

    @Override
    public CompletableFuture<LLMOutput> reasonNextStep(LLMOrchestrationRequest request) {
        return this.extensionsClient.execute(EXTENSION_NAME, "CHAT-answer-prompt", params -> ((OperationParameterizer)((OperationParameterizer)((OperationParameterizer)((OperationParameterizer)params.withConfigRef(this.configRef)).withParameter("General", "prompt", (Object)request.getPrompt())).withParameter(SETTINGS_PARAM_GROUP, "modelApiName", (Object)this.model.getModelApiName())).withParameter(SETTINGS_PARAM_GROUP, "probability", (Object)this.model.getProbability())).withParameter(SETTINGS_PARAM_GROUP, "locale", (Object)this.model.getLocale())).thenApply(result -> this.serializer.parseNextStep((InputStream)result.getOutput()));
    }
}

