/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.conductor.internal.operation.loop;

import com.mulesoft.modules.agent.conductor.api.model.Orchestration;
import com.mulesoft.modules.agent.conductor.api.model.a2a.A2AClient;
import com.mulesoft.modules.agent.conductor.api.model.llm.LLMSettings;
import com.mulesoft.modules.agent.conductor.api.model.mcp.McpServer;
import com.mulesoft.modules.agent.conductor.api.model.tool.Tool;
import com.mulesoft.modules.agent.conductor.internal.datasense.ToolInputResolver;
import com.mulesoft.modules.agent.conductor.internal.extension.AgentConductor;
import com.mulesoft.modules.agent.conductor.internal.llm.client.LLMClientFactory;
import com.mulesoft.modules.agent.conductor.internal.operation.loop.Loop;
import com.mulesoft.modules.agent.conductor.internal.operation.loop.LoopErrorTypeProvider;
import com.mulesoft.modules.agent.conductor.internal.prompt.PromptBuilder;
import com.mulesoft.modules.agent.conductor.internal.serializer.LLMSerializer;
import com.mulesoft.modules.agent.conductor.internal.state.TaskContextService;
import com.mulesoft.modules.agent.conductor.internal.state.model.TaskContext;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolHandler;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolRequest;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolResponse;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolType;
import com.mulesoft.modules.agent.conductor.internal.tool.a2a.A2AToolService;
import com.mulesoft.modules.agent.conductor.internal.tool.custom.CustomToolResponse;
import com.mulesoft.modules.agent.conductor.internal.tool.mcp.McpService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.sdk.api.annotation.metadata.ChainInputResolver;
import org.mule.sdk.api.annotation.route.ChainExecutionOccurrence;
import org.mule.sdk.api.annotation.route.ExecutionOccurrence;

public class LoopOperation {
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private LLMSerializer serializer;
    @Inject
    private LLMClientFactory llmClientFactory;
    @Inject
    private McpService mcpService;
    @Inject
    private A2AToolService a2aToolService;
    @Inject
    private TaskContextService taskContextService;

    @Execution(value=ExecutionType.CPU_LITE)
    @Throws(value={LoopErrorTypeProvider.class})
    public void agentLoop(@Config AgentConductor config, @Optional @Expression(value=ExpressionSupport.REQUIRED) String taskId, @Optional @Expression(value=ExpressionSupport.REQUIRED) String contextId, @Content(primary=true) String prompt, LLMSettings llm, @Optional @Content String instructions, @Optional @Content String groundings, @ParameterDsl(allowReferences=false) @Optional @NullSafe List<McpServer> mcpServers, @ParameterDsl(allowReferences=false) @Alias(value="a2aClients") @Optional @NullSafe List<A2AClient> a2aClients, @Optional @NullSafe @ExecutionOccurrence(value=ChainExecutionOccurrence.MULTIPLE_OR_NONE) @ChainInputResolver(value=ToolInputResolver.class) List<Tool> tools, @ConfigOverride Integer maxNumberOfLoops, @ConfigOverride Integer maxConsecutiveErrors, CompletionCallback<Orchestration, Void> completionCallback) {
        this.collectTools(tools, mcpServers, a2aClients).whenComplete((toolHandlers, e) -> {
            if (e != null) {
                completionCallback.error(e);
                return;
            }
            PromptBuilder promptBuilder = new PromptBuilder(this.expressionManager).setUserPrompt(prompt).setUserInstructions(instructions).setGroundings(groundings).setTools(toolHandlers.values()).setMaxLoops(maxNumberOfLoops);
            Loop loop = new Loop(promptBuilder, this.llmClientFactory.getClient(llm), this.a2aToolService, (Map<String, ToolHandler>)toolHandlers, this.nonBlank(taskId), this.nonBlank(contextId), maxNumberOfLoops, maxConsecutiveErrors, this.taskContextService, (ObjectStore<TaskContext>)config.getConversationStateObjectStore(), config.getConfigName(), completionCallback);
            this.schedulerService.ioScheduler().submit(loop::start);
        });
    }

    private CheckedFunction<ToolRequest, CompletableFuture<ToolResponse>> routeToolHandler(Tool tool) {
        return request -> {
            CompletableFuture future = new CompletableFuture();
            tool.getChain().process(request, null, result -> future.complete(new CustomToolResponse(this.serializer.asString(result))), (t, r) -> future.completeExceptionally((Throwable)t));
            return future;
        };
    }

    private CompletableFuture<Map<String, ToolHandler>> collectTools(List<Tool> routeTools, List<McpServer> mcpServers, List<A2AClient> a2aClients) {
        try {
            LinkedHashMap<String, ToolHandler> toolHandlers = new LinkedHashMap<String, ToolHandler>();
            if (routeTools != null) {
                for (Tool tool : routeTools) {
                    toolHandlers.put(tool.getName(), new ToolHandler(tool.getName(), tool.getDescription(), tool.getInput(), tool.getOutput(), ToolType.CUSTOM, this.routeToolHandler(tool)));
                }
            }
            CompletableFuture<Map<String, ToolHandler>> mcpHandlers = this.mcpService.getMcpTools(mcpServers);
            CompletableFuture<Map<String, ToolHandler>> a2aHandlers = this.a2aToolService.getA2AToolHandlers(a2aClients);
            return mcpHandlers.thenCombine(a2aHandlers, (mcpTools, a2aTools) -> {
                toolHandlers.putAll((Map<String, ToolHandler>)mcpTools);
                toolHandlers.putAll((Map<String, ToolHandler>)a2aTools);
                return toolHandlers;
            });
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private String nonBlank(String input) {
        return StringUtils.isBlank((String)input) ? UUID.randomUUID().toString() : input;
    }
}

