/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.conductor.internal.state.model;

import com.mulesoft.modules.agent.conductor.internal.state.model.AgentToolContext;
import com.mulesoft.modules.agent.conductor.internal.state.model.ConversationState;
import com.mulesoft.modules.agent.conductor.internal.state.model.Iteration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TaskContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String contextId;
    private String taskId;
    private int currentIteration = 0;
    private List<Iteration> iterations = new ArrayList<Iteration>();
    private ConversationState conversationState = new ConversationState();
    private String conversationHistory = "";
    private Map<String, AgentToolContext> agentToolContexts = new ConcurrentHashMap<String, AgentToolContext>();

    public TaskContext(String id, String taskId, String contextId) {
        this.id = id;
        this.taskId = taskId;
        this.contextId = contextId;
    }

    public void reset() {
        this.conversationHistory = "";
        this.iterations.clear();
        this.conversationState = new ConversationState();
    }

    public String getId() {
        return this.id;
    }

    public String getContextId() {
        return this.contextId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public AgentToolContext getAgentToolContext(String toolName) {
        return this.agentToolContexts.computeIfAbsent(toolName, t -> new AgentToolContext());
    }

    public void addIteration(Iteration iteration) {
        this.iterations.add(iteration);
    }

    public Iteration getLastIteration() {
        if (this.iterations.isEmpty()) {
            Iteration iteration = new Iteration();
            this.addIteration(iteration);
            return iteration;
        }
        return this.iterations.get(this.iterations.size() - 1);
    }

    public List<Iteration> getIterations() {
        return this.iterations;
    }

    public ConversationState getConversationState() {
        return this.conversationState;
    }

    public String getConversationHistory() {
        return this.conversationHistory;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setCurrentIteration(int currentIteration) {
        this.currentIteration = currentIteration;
    }

    public void setIterations(List<Iteration> iterations) {
        this.iterations = iterations;
    }

    public void setCurrentState(ConversationState conversationState) {
        this.conversationState = conversationState;
    }

    public void setConversationHistory(String conversationHistory) {
        this.conversationHistory = conversationHistory;
    }
}

