/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.conductor.internal.tool.mcp;

import com.mulesoft.modules.agent.conductor.api.model.mcp.McpServer;
import com.mulesoft.modules.agent.conductor.api.model.mcp.ToolFilter;
import com.mulesoft.modules.agent.conductor.internal.error.ConductorErrorTypes;
import com.mulesoft.modules.agent.conductor.internal.serializer.DwConverter;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolHandler;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolRequest;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolResponse;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolType;
import com.mulesoft.modules.agent.conductor.internal.tool.mcp.McpToolInfo;
import com.mulesoft.modules.agent.conductor.internal.tool.mcp.McpToolResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class McpService
implements Initialisable {
    private static final DataType MAP_DATA_TYPE = DataType.fromType(Map.class);
    private static final DataType MCP_TOOL_INFO_DATA_TYPE = DataType.fromType(McpToolInfo.class);
    private static final String MCP = "MCP";
    @Inject
    private ExtensionsClient extensionsClient;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private SchedulerService schedulerService;
    private final Map<String, List<McpToolInfo>> cache = new ConcurrentHashMap<String, List<McpToolInfo>>();
    private DwConverter mapWriter;
    private DwConverter toolInfoReader;
    private DwConverter jsonWriter;

    public void initialise() throws InitialisationException {
        this.mapWriter = new DwConverter(this.expressionManager, "%dw 2.0 output application/java --- payload", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.fromObject((Object)value))));
        this.toolInfoReader = new DwConverter(this.expressionManager, "%dw 2.0\noutput application/java\n---\n  {\n    toolName: payload.name,\n    description: payload.description,\n    \"input\": payload.inputSchema,\n    \"output\": \"A standard MCP response, such as Text, Blob or image type. Blobs and image responses will be base64 encoded\"\n  }\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, MAP_DATA_TYPE)));
        this.jsonWriter = new DwConverter(this.expressionManager, "%dw 2.0\noutput application/java\n---\nwrite(payload, \"json\") as String\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.fromObject((Object)value))));
    }

    public CompletableFuture<Map<String, ToolHandler>> getMcpTools(List<McpServer> mcpServers) {
        if (null == mcpServers || mcpServers.isEmpty()) {
            return CompletableFuture.completedFuture(Map.of());
        }
        return new McpDiscovery(mcpServers).getTools();
    }

    private class McpDiscovery {
        private final List<McpServer> mcpServers;
        private final Map<String, ToolHandler> tools = new ConcurrentHashMap<String, ToolHandler>();
        private final AtomicInteger countDown;
        private final CompletableFuture<Map<String, ToolHandler>> future = new CompletableFuture();

        private McpDiscovery(List<McpServer> mcpServers) {
            this.mcpServers = mcpServers;
            this.countDown = new AtomicInteger(mcpServers.size());
        }

        public CompletableFuture<Map<String, ToolHandler>> getTools() {
            try {
                for (McpServer mcpServer : this.mcpServers) {
                    String mcpConfigRef = mcpServer.getMcpClientConfigRef();
                    List<McpToolInfo> mcpTools = McpService.this.cache.get(mcpConfigRef);
                    if (mcpTools != null) {
                        mcpTools.forEach(this::collect);
                        continue;
                    }
                    McpService.this.schedulerService.ioScheduler().submit(() -> this.fetchTools(mcpServer));
                }
            }
            catch (Exception ex) {
                this.future.completeExceptionally(ex);
            }
            return this.future;
        }

        private void fetchTools(McpServer mcpServer) {
            String mcpConfigRef = mcpServer.getMcpClientConfigRef();
            McpService.this.extensionsClient.execute(McpService.MCP, "listTools", params -> params.withConfigRef(mcpConfigRef)).whenComplete((result, t) -> {
                if (t != null) {
                    this.handleToolParsingException(this.countDown, this.future, (Throwable)t, mcpConfigRef);
                } else {
                    try {
                        List<McpToolInfo> tools = this.parseTools(mcpServer, (Result<Object, Object>)result, mcpConfigRef);
                        if (!tools.isEmpty()) {
                            tools.forEach(this::collect);
                            McpService.this.cache.put(mcpConfigRef, tools);
                        }
                    }
                    catch (Exception e) {
                        this.handleToolParsingException(this.countDown, this.future, e, mcpConfigRef);
                    }
                }
            });
        }

        private List<McpToolInfo> parseTools(McpServer mcpServer, Result<Object, Object> result, String mcpConfigRef) {
            Iterator iterator = (Iterator)result.getOutput();
            ArrayList<McpToolInfo> tools = new ArrayList<McpToolInfo>();
            iterator.forEachRemaining(value -> {
                McpToolInfo toolInfo = (McpToolInfo)McpService.this.toolInfoReader.evaluate(value, MCP_TOOL_INFO_DATA_TYPE);
                String toolName = toolInfo.getToolName();
                if (this.isAllowed(toolName, mcpServer.getToolsFilter())) {
                    String toolId = mcpConfigRef + "." + toolName;
                    toolInfo.setToolId(toolId);
                    toolInfo.setConfigRef(mcpConfigRef);
                    tools.add(toolInfo);
                }
            });
            return tools;
        }

        private void collect(McpToolInfo toolInfo) {
            this.tools.put(toolInfo.getToolId(), new ToolHandler(toolInfo.getToolId(), toolInfo.getDescription(), toolInfo.getInput(), toolInfo.getOutput(), ToolType.MCP, this.createHandler(toolInfo.getConfigRef(), toolInfo.getToolName())));
            if (this.countDown.decrementAndGet() <= 0) {
                this.future.complete(this.tools);
            }
        }

        private boolean isAllowed(String toolName, ToolFilter filter) {
            List<String> values = filter.getAllowedTools();
            if (values != null && !values.isEmpty()) {
                return values.contains(toolName);
            }
            values = filter.getDisallowedTools();
            if (values != null && !values.isEmpty()) {
                return !values.contains(toolName);
            }
            return true;
        }

        private CheckedFunction<ToolRequest, CompletableFuture<ToolResponse>> createHandler(String configRef, String toolName) {
            return request -> McpService.this.extensionsClient.execute(McpService.MCP, "callTool", params -> ((OperationParameterizer)((OperationParameterizer)params.withConfigRef(configRef)).withParameter("toolName", (Object)toolName)).withParameter("arguments", McpService.this.mapWriter.evaluate(new TypedValue((Object)request.getToolInput(), DataType.JSON_STRING), MAP_DATA_TYPE))).thenApply(result -> new McpToolResponse(McpService.this.jsonWriter.evaluateAsString(result.getOutput(), DataType.JSON_STRING)));
        }

        private void handleToolParsingException(AtomicInteger countDown, CompletableFuture<?> future, Throwable t, String mcpConfigRef) {
            future.completeExceptionally((Throwable)new ModuleException("Exception obtaining toolList from MCP client config %s: %s".formatted(mcpConfigRef, t.getMessage()), (ErrorTypeDefinition)ConductorErrorTypes.TOOL_ERROR, t));
            countDown.set(-1);
        }
    }
}

