/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.conductor.internal.extension;

import com.mulesoft.modules.agent.conductor.api.model.llm.LLMSettings;
import com.mulesoft.modules.agent.conductor.api.model.llm.einstein.EinsteinSettings;
import com.mulesoft.modules.agent.conductor.internal.error.ConductorErrorTypes;
import com.mulesoft.modules.agent.conductor.internal.operation.loop.LoopOperation;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.sdk.api.annotation.JavaVersionSupport;
import org.mule.sdk.api.meta.JavaVersion;

@Extension(name="Agents Conductor", category=Category.SELECT)
@JavaVersionSupport(value={JavaVersion.JAVA_17})
@Operations(value={LoopOperation.class})
@RequiresEnterpriseLicense(allowEvaluationLicense=true)
@ErrorTypes(value=ConductorErrorTypes.class)
@SubTypeMapping(baseType=LLMSettings.class, subTypes={EinsteinSettings.class})
@Xml(prefix="agents-conductor")
public class AgentConductor
implements Initialisable,
Startable,
Stoppable {
    @Inject
    private ObjectStoreManager objectStoreManager;
    @RefName
    private String configName;
    @Parameter
    @Optional(defaultValue="25")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Max Number of Loops")
    @Summary(value="The maximum number of iterations to control the flow's execution.")
    private Integer maxNumberOfLoops;
    @Parameter
    @Optional(defaultValue="3")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Max Consecutive Errors")
    @Summary(value="The maximum number of errors that the orchestrator will attempt to self-heal before returning a failed status.")
    private Integer maxConsecutiveErrors;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Conversation State ObjectStore")
    @Summary(value="Object Store for managing the state of task execution.")
    @ObjectStoreReference
    private ObjectStore conversationStateObjectStore;

    public void initialise() throws InitialisationException {
        if (this.conversationStateObjectStore == null) {
            this.conversationStateObjectStore = this.objectStoreManager.getOrCreateObjectStore("_conductorModule_" + this.configName + "_conversationState", ObjectStoreSettings.builder().persistent(true).entryTtl(Long.valueOf(TimeUnit.HOURS.toMillis(1L))).build());
            try {
                this.conversationStateObjectStore.open();
            }
            catch (ObjectStoreException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.conversationStateObjectStore);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.conversationStateObjectStore);
    }

    public ObjectStore getConversationStateObjectStore() {
        return this.conversationStateObjectStore;
    }

    public String getConfigName() {
        return this.configName;
    }
}

