/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.conductor.internal.serializer;

import com.mulesoft.modules.agent.conductor.internal.serializer.BaseDWSerializer;
import com.mulesoft.modules.agent.conductor.internal.serializer.DwConverter;
import com.mulesoft.modules.agent.conductor.internal.state.model.LLMOutput;
import java.io.InputStream;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class LLMSerializer
extends BaseDWSerializer
implements Initialisable {
    private static final DataType LLM_OUTPUT_DATA_TYPE = DataType.fromType(LLMOutput.class);
    private static final DataType JSON_STREAM = DataType.builder().type(InputStream.class).mediaType(MediaType.APPLICATION_JSON).build();
    private DwConverter llmOutputReader;
    private DwConverter toStringReader;

    public LLMOutput parseNextStep(InputStream json) {
        try {
            return (LLMOutput)this.llmOutputReader.evaluate(json, LLM_OUTPUT_DATA_TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T, A> String asString(Result<T, A> result) {
        return this.toStringReader.evaluateAsString(result.getOutput(), DataType.STRING);
    }

    public void initialise() {
        this.llmOutputReader = new DwConverter(this.expressionManager, "%dw 2.0\noutput application/java\n\nvar response = read(payload.response, \"json\")\nfun parse(value) = (if ((typeOf(value) as String) == \"Object\") (\n  write(value, \"json\") as String) else (write(value, \"text\") as String))\n---\n{\n    toolToCall: response.toolToCall default null,\n    toolInput: parse(response.toolInput),\n    result: parse(response.result),\n    reasoning: response.reasoning default \"\",\n    goalComplete: response.goalComplete default false,\n    additionalInputNeeded: response.additionalInputNeeded default false\n}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, JSON_STREAM)));
        this.toStringReader = new DwConverter(this.expressionManager, "output application/java\n---\npayload as String\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.fromObject((Object)value))));
    }
}

