/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.conductor.internal.prompt;

import com.mulesoft.modules.agent.conductor.internal.tool.Tool;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;

public class PromptBuilder {
    private static final String PROMPT_TEMPLATE;
    private final ExpressionManager expressionManager;
    private String userPrompt;
    private String userInstructions;
    private Collection<Tool> tools = List.of();
    private String groundings;
    private String conversationHistory;
    private Integer currentLoopIteration = 1;
    private Integer maxLoops;
    private String formattedTools;

    public PromptBuilder(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public PromptBuilder setUserPrompt(String userPrompt) {
        if (StringUtils.isBlank((String)userPrompt)) {
            throw new IllegalArgumentException("User prompt cannot be null or empty");
        }
        this.userPrompt = userPrompt;
        return this;
    }

    public PromptBuilder setTools(Collection<Tool> tools) {
        this.tools = tools != null ? tools : List.of();
        this.formattedTools = null;
        return this;
    }

    public PromptBuilder setConversationHistory(String conversationHistory) {
        this.conversationHistory = conversationHistory;
        return this;
    }

    public PromptBuilder setCurrentLoopIteration(Integer currentLoopIteration) {
        if (currentLoopIteration == null) {
            throw new IllegalArgumentException("Current loop iteration cannot be null");
        }
        if (currentLoopIteration < 1) {
            throw new IllegalArgumentException("Current loop iteration cannot be lower than one");
        }
        this.currentLoopIteration = currentLoopIteration;
        return this;
    }

    public PromptBuilder setMaxLoops(Integer maxLoops) {
        if (maxLoops == null) {
            throw new IllegalArgumentException("Max loops cannot be null");
        }
        if (maxLoops < 1) {
            throw new IllegalArgumentException("Max loops cannot be lower than 1");
        }
        this.maxLoops = maxLoops;
        return this;
    }

    public PromptBuilder setGroundings(String groundings) {
        this.groundings = groundings;
        return this;
    }

    public PromptBuilder setUserInstructions(String userInstructions) {
        this.userInstructions = userInstructions;
        return this;
    }

    public String build() {
        return PROMPT_TEMPLATE.replace("{{userPrompt}}", this.userPrompt).replace("{{instructions}}", this.nullSafe(this.userInstructions)).replace("{{tools}}", this.getFormattedTools()).replace("{{conversationHistory}}", this.nullSafe(this.conversationHistory)).replace("{{currentLoopIteration}}", String.valueOf(this.currentLoopIteration)).replace("{{groundings}}", this.nullSafe(this.groundings)).replace("{{maxLoops}}", String.valueOf(this.maxLoops));
    }

    private String nullSafe(String value) {
        return StringUtils.isBlank((String)value) ? "None" : value;
    }

    private String getFormattedTools() {
        if (this.formattedTools == null) {
            StringBuilder builder = new StringBuilder();
            if (this.tools.isEmpty()) {
                this.formattedTools = "No Tools available";
            } else {
                this.tools.forEach(tool -> builder.append("\n- **").append(tool.getId()).append("**:\n").append("Description:\n```\n").append(tool.getDescription()).append("\n```\n").append("\nInput:\n```\n").append(tool.getInput()).append("\n```\n").append("\nOutput:\n```\n").append(tool.getOutput()).append("\n```\n\n"));
                this.formattedTools = builder.toString();
            }
        }
        return this.formattedTools;
    }

    public String getUserPrompt() {
        return this.userPrompt;
    }

    public String getGroundings() {
        return this.groundings;
    }

    public String getUserInstructions() {
        return this.userInstructions;
    }

    static {
        try {
            PROMPT_TEMPLATE = IOUtils.toString((InputStream)PromptBuilder.class.getClassLoader().getResourceAsStream("agent-loop/prompt-template.txt"));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed to load prompt template"), (Throwable)e);
        }
    }
}

