/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.conductor.api.model;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

import java.io.Serializable;

public class Orchestration implements Serializable {

  @Parameter
  private String taskId;

  @Parameter
  private String contextId;

  @Parameter
  private String response;

  @Parameter
  private boolean goalComplete;

  @Parameter
  private boolean inputRequired;

  @Parameter
  private int iterationsCount;

  @Parameter
  @Optional
  private String reasoning;

  // for serialization purposes
  public Orchestration() {}

  public Orchestration(String taskId,
                       String contextId,
                       String response,
                       boolean goalComplete,
                       boolean inputRequired,
                       int iterationsCount,
                       String reasoning) {
    this.taskId = taskId;
    this.contextId = contextId;
    this.response = response;
    this.goalComplete = goalComplete;
    this.inputRequired = inputRequired;
    this.iterationsCount = iterationsCount;
    this.reasoning = reasoning;
  }

  public String getTaskId() {
    return taskId;
  }

  public String getContextId() {
    return contextId;
  }

  public int getIterationsCount() {
    return iterationsCount;
  }

  public boolean isGoalComplete() {
    return goalComplete;
  }

  public String getReasoning() {
    return reasoning;
  }

  public String getResponse() {
    return response;
  }

  public boolean isInputRequired() {
    return inputRequired;
  }
}
