/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.conductor.api.model.llm.einstein;

import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;

import com.mulesoft.modules.agent.conductor.api.model.llm.LLMSettings;

@TypeDsl(allowTopLevelDefinition = true)
public class EinsteinSettings extends LLMSettings {

  @Parameter
  @ConfigReference(namespace = "MS-EINSTEIN-AI", name = "CONFIG")
  private String einsteinAiConfigRef;

  @ParameterGroup(name = "Model settings")
  private EinsteinModel model;

  public String getEinsteinAiConfigRef() {
    return einsteinAiConfigRef;
  }

  public EinsteinModel getModel() {
    return model;
  }
}


