/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.conductor.internal.llm.client;

import static org.mule.runtime.api.util.Preconditions.checkArgument;

import org.mule.runtime.extension.api.client.ExtensionsClient;

import com.mulesoft.modules.agent.conductor.api.model.llm.LLMSettings;
import com.mulesoft.modules.agent.conductor.api.model.llm.einstein.EinsteinSettings;
import com.mulesoft.modules.agent.conductor.internal.llm.client.einstein.EinsteinClient;
import com.mulesoft.modules.agent.conductor.internal.serializer.LLMSerializer;

import javax.inject.Inject;

public class LLMClientFactory {

  @Inject
  private ExtensionsClient extensionsClient;

  @Inject
  private LLMSerializer llmSerializer;

  public LLMClient getClient(LLMSettings llmSettings) {
    checkArgument(llmSettings != null, "LLM settings cannot be null");
    if (llmSettings instanceof EinsteinSettings einsteinSettings) {
      return new EinsteinClient(einsteinSettings.getEinsteinAiConfigRef(), einsteinSettings.getModel(), extensionsClient,
                                llmSerializer);
    }

    throw new IllegalArgumentException("LLM settings must be einstein settings");
  }

}
