/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.conductor.internal.serializer;

import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.IOUtils;

import java.util.function.BiConsumer;

public class DwConverter {

  private final ExpressionManager expressionManager;
  private final CompiledExpression expression;
  private final BiConsumer<Object, BindingContext.Builder> bindingConfigurer;

  public DwConverter(ExpressionManager expressionManager,
                     String expression,
                     BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
    this(expressionManager, expression, null, bindingConfigurer);
  }

  public DwConverter(ExpressionManager expressionManager,
                     String expression,
                     Object defaultBindingValue,
                     BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
    this.expressionManager = expressionManager;
    this.bindingConfigurer = bindingConfigurer;
    this.expression = expressionManager.compile(expression, bind(defaultBindingValue));
  }

  private BindingContext bind(Object value) {
    BindingContext.Builder builder = BindingContext.builder();
    bindingConfigurer.accept(value, builder);
    return builder.build();
  }

  public <T> T evaluate(Object value, DataType expected) {
    try (var session = expressionManager.openSession(bind(value))) {
      return (T) session.evaluate(expression, expected).getValue();
    }
  }

  public String evaluateAsString(Object value, DataType expected) {
    Object result = evaluate(value, expected);
    if (result instanceof CursorStreamProvider provider) {
      return IOUtils.toString(provider.openCursor());
    } else if (result instanceof String string) {
      return string;
    } else {
      throw new IllegalStateException("Expected CursorStreamProvider or String, got "
          + (result == null ? "null" : result.getClass().getName()));
    }
  }
}
