/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.conductor.internal.tracing;

import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

import com.mulesoft.modules.agent.conductor.internal.extension.AgentConductor;

public final class TracingUtils {

  private static final String ARTIFACT_TYPE = "artifact.type";
  private static final String MULESOFT_ENTITY_TYPE = "mulesoft.entity.type";
  private static final String AGENT_NAME = "agent.name";
  private static final String AGENT_CONDUCTOR = "agent/conductor";

  private TracingUtils() {}

  public static void traceConductor(AgentConductor agent, DistributedTraceContextManager contextManager) {
    contextManager.setCurrentSpanName("[CONDUCTOR] " + agent.getConfigName());
    contextManager.addCurrentSpanAttribute(MULESOFT_ENTITY_TYPE, AGENT_CONDUCTOR);
    contextManager.addCurrentSpanAttribute(ARTIFACT_TYPE, AGENT_CONDUCTOR);
    contextManager.addCurrentSpanAttribute(AGENT_NAME, agent.getConfigName());
  }
}
