/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.conductor.internal.llm.client;

import com.mulesoft.modules.agent.conductor.api.model.llm.LLMSettings;
import com.mulesoft.modules.agent.conductor.api.model.llm.einstein.EinsteinSettings;
import com.mulesoft.modules.agent.conductor.internal.llm.client.LLMClient;
import com.mulesoft.modules.agent.conductor.internal.llm.client.einstein.EinsteinClient;
import com.mulesoft.modules.agent.conductor.internal.serializer.LLMSerializer;
import javax.inject.Inject;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.client.ExtensionsClient;

public class LLMClientFactory {
    @Inject
    private ExtensionsClient extensionsClient;
    @Inject
    private LLMSerializer llmSerializer;

    public LLMClient getClient(LLMSettings llmSettings) {
        Preconditions.checkArgument((llmSettings != null ? 1 : 0) != 0, (String)"LLM settings cannot be null");
        if (llmSettings instanceof EinsteinSettings) {
            EinsteinSettings einsteinSettings = (EinsteinSettings)llmSettings;
            return new EinsteinClient(einsteinSettings.getEinsteinAiConfigRef(), einsteinSettings.getModel(), this.extensionsClient, this.llmSerializer);
        }
        throw new IllegalArgumentException("LLM settings must be einstein settings");
    }
}

