/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.conductor.internal.operation.loop;

import com.mulesoft.modules.agent.conductor.api.model.Orchestration;
import com.mulesoft.modules.agent.conductor.api.model.a2a.A2AClient;
import com.mulesoft.modules.agent.conductor.api.model.llm.LLMSettings;
import com.mulesoft.modules.agent.conductor.api.model.mcp.McpServer;
import com.mulesoft.modules.agent.conductor.api.model.tool.CustomToolRoute;
import com.mulesoft.modules.agent.conductor.internal.datasense.ToolInputResolver;
import com.mulesoft.modules.agent.conductor.internal.extension.AgentConductor;
import com.mulesoft.modules.agent.conductor.internal.llm.client.LLMClientFactory;
import com.mulesoft.modules.agent.conductor.internal.operation.loop.Loop;
import com.mulesoft.modules.agent.conductor.internal.operation.loop.LoopErrorTypeProvider;
import com.mulesoft.modules.agent.conductor.internal.prompt.PromptBuilder;
import com.mulesoft.modules.agent.conductor.internal.serializer.LLMSerializer;
import com.mulesoft.modules.agent.conductor.internal.state.TaskContextService;
import com.mulesoft.modules.agent.conductor.internal.state.model.TaskContext;
import com.mulesoft.modules.agent.conductor.internal.tool.Tool;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolRequest;
import com.mulesoft.modules.agent.conductor.internal.tool.ToolResponse;
import com.mulesoft.modules.agent.conductor.internal.tool.a2a.A2AToolService;
import com.mulesoft.modules.agent.conductor.internal.tool.custom.CustomToolResponse;
import com.mulesoft.modules.agent.conductor.internal.tool.mcp.McpService;
import com.mulesoft.modules.agent.conductor.internal.tracing.TracingUtils;
import com.mulesoft.modules.agent.conductor.internal.util.ExceptionUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.sdk.api.annotation.metadata.ChainInputResolver;
import org.mule.sdk.api.annotation.route.ChainExecutionOccurrence;
import org.mule.sdk.api.annotation.route.ExecutionOccurrence;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

public class LoopOperation {
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private LLMSerializer serializer;
    @Inject
    private LLMClientFactory llmClientFactory;
    @Inject
    private McpService mcpService;
    @Inject
    private A2AToolService a2aToolService;
    @Inject
    private TaskContextService taskContextService;

    @Execution(value=ExecutionType.CPU_LITE)
    @Throws(value={LoopErrorTypeProvider.class})
    public void agentLoop(@Config AgentConductor config, @Optional @Expression(value=ExpressionSupport.REQUIRED) String taskId, @Optional @Expression(value=ExpressionSupport.REQUIRED) String contextId, @Content(primary=true) String prompt, LLMSettings llm, @Optional @Content String instructions, @Optional @Content String groundings, @ParameterDsl(allowReferences=false) @Optional @NullSafe List<McpServer> mcpServers, @ParameterDsl(allowReferences=false) @Alias(value="a2aClients") @Optional @NullSafe List<A2AClient> a2aClients, @Optional @NullSafe @ExecutionOccurrence(value=ChainExecutionOccurrence.MULTIPLE_OR_NONE) @ChainInputResolver(value=ToolInputResolver.class) List<CustomToolRoute> tools, @ConfigOverride Integer maxNumberOfLoops, @ConfigOverride Integer maxConsecutiveErrors, DistributedTraceContextManager traceContextManager, ExtensionsClient extensionsClient, CompletionCallback<Orchestration, Void> completionCallback) {
        TracingUtils.traceConductor(config, traceContextManager);
        this.collectTools(tools, mcpServers, a2aClients, extensionsClient).whenComplete((collectedTools, e) -> {
            if (e != null) {
                completionCallback.error(ExceptionUtils.unwrap(e));
                return;
            }
            PromptBuilder promptBuilder = new PromptBuilder(this.expressionManager).setUserPrompt(prompt).setUserInstructions(instructions).setGroundings(groundings).setTools(collectedTools.values()).setMaxLoops(maxNumberOfLoops);
            Loop loop = new Loop(promptBuilder, this.llmClientFactory.getClient(llm), (Map<String, Tool>)collectedTools, this.nonBlank(taskId), this.nonBlank(contextId), maxNumberOfLoops, maxConsecutiveErrors, this.taskContextService, (ObjectStore<TaskContext>)config.getConversationStateObjectStore(), config.getConfigName(), extensionsClient, completionCallback);
            this.schedulerService.ioScheduler().submit(loop::start);
        });
    }

    private CompletableFuture<Map<String, Tool>> collectTools(List<CustomToolRoute> routeTools, List<McpServer> mcpServers, List<A2AClient> a2aClients, ExtensionsClient extensionsClient) {
        try {
            LinkedHashMap<String, CustomTool> tools = new LinkedHashMap<String, CustomTool>();
            if (routeTools != null) {
                for (CustomToolRoute tool : routeTools) {
                    tools.put(tool.getName(), new CustomTool(tool.getName(), tool.getDescription(), tool.getInput(), tool.getOutput(), tool));
                }
            }
            CompletableFuture<Map<String, Tool>> mcpFuture = this.mcpService.getTools(mcpServers, extensionsClient);
            CompletableFuture<Map<String, Tool>> a2aFuture = this.a2aToolService.getTools(a2aClients, extensionsClient);
            return mcpFuture.thenCombine(a2aFuture, (mcpTools, a2aTools) -> {
                tools.putAll((Map<String, CustomTool>)mcpTools);
                tools.putAll((Map<String, CustomTool>)a2aTools);
                return tools;
            });
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(ExceptionUtils.unwrap(e));
        }
    }

    private String nonBlank(String input) {
        return StringUtils.isBlank((String)input) ? UUID.randomUUID().toString() : input;
    }

    private class CustomTool
    extends Tool {
        private final CustomToolRoute toolRoute;

        public CustomTool(String name, String description, String input, String output, CustomToolRoute toolRoute) {
            super(name, name, description, input, output);
            this.toolRoute = toolRoute;
        }

        @Override
        public CompletableFuture<ToolResponse> execute(ToolRequest request, ExtensionsClient extensionsClient) {
            CompletableFuture<ToolResponse> future = new CompletableFuture<ToolResponse>();
            this.toolRoute.getChain().process((Object)request, null, result -> future.complete(new CustomToolResponse(LoopOperation.this.serializer.asString(result))), (t, r) -> future.completeExceptionally((Throwable)t));
            return future;
        }
    }
}

