/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.openai;

import com.mulesoft.modules.agent.broker.internal.extension.connection.BaseConnectionProvider;
import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAIClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAISettings;
import com.openai.client.okhttp.OpenAIOkHttpClient;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;

@Alias(value="openai")
public class OpenAIConnectionProvider
extends BaseConnectionProvider
implements CachedConnectionProvider<LLMClient>,
NoConnectivityTest {
    @ParameterGroup(name="OpenAI Settings")
    private OpenAISettings openAISettings;

    public LLMClient connect() throws ConnectionException {
        OpenAIOkHttpClient.Builder builder = OpenAIOkHttpClient.builder();
        if (this.openAISettings.getUrl() != null) {
            builder.baseUrl(this.openAISettings.getUrl());
        }
        com.openai.client.OpenAIClient client = builder.apiKey(this.openAISettings.getApiKey()).build();
        return new OpenAIClient(client, this.openAISettings);
    }

    public ConnectionValidationResult validate(LLMClient llmClient) {
        return ConnectionValidationResult.success();
    }
}

