/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.state;

import com.mulesoft.modules.agent.broker.internal.state.model.TaskContext;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskContextService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskContextService.class);
    @Inject
    private LockFactory lockFactory;

    public void upsertTaskContext(TaskContext taskContext, String configRef, ObjectStore<TaskContext> taskContextStore) throws ObjectStoreException {
        this.withLock(taskContext.getTaskId(), taskContext.getContextId(), configRef, storeKey -> {
            if (taskContextStore.contains(storeKey)) {
                taskContextStore.remove(storeKey);
            }
            taskContextStore.store(storeKey, (Serializable)taskContext);
            return null;
        });
    }

    public TaskContext getOrCreate(String taskId, String contextId, String configRefName, ObjectStore<TaskContext> taskContextStore) throws ObjectNotFoundException, ObjectStoreException {
        return (TaskContext)this.withLock(taskId, contextId, configRefName, storeKey -> {
            if (taskContextStore.contains(storeKey)) {
                return (TaskContext)taskContextStore.retrieve(storeKey);
            }
            return new TaskContext((String)storeKey, taskId, contextId);
        });
    }

    public void remove(String taskId, String contextId, String configRefName, ObjectStore<TaskContext> taskContextStore) throws ObjectStoreException {
        LOGGER.debug("Clearing task context for contextId {}", (Object)contextId);
        this.withLock(taskId, contextId, configRefName, storeKey -> {
            try {
                taskContextStore.remove(storeKey);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.debug("Could not remove context with id {} because it doesn't exist. Resuming...", (Object)contextId);
            }
            return null;
        });
    }

    private <T> T withLock(String taskId, String contextId, String configRef, CheckedFunction<String, T> function) throws ObjectStoreException {
        Lock lock = this.lockFactory.createLock(this.getLockKey(contextId, configRef));
        lock.lock();
        try {
            Object object = function.apply((Object)this.getStoreKey(taskId, contextId, configRef));
            return (T)object;
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof ObjectStoreException) {
                ObjectStoreException e = (ObjectStoreException)cause;
                throw e;
            }
            throw new ObjectStoreException(cause);
        }
        finally {
            lock.unlock();
        }
    }

    private String getLockKey(String contextId, String configRefName) {
        return "_loop-state-store-" + configRefName + "-" + contextId;
    }

    private String getStoreKey(String taskId, String contextId, String configRef) {
        return "[" + configRef + "]-" + taskId + "-" + contextId;
    }
}

