/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.tool.a2a;

import com.mulesoft.modules.agent.broker.api.model.a2a.A2AClient;
import com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes;
import com.mulesoft.modules.agent.broker.internal.serializer.DwConverter;
import com.mulesoft.modules.agent.broker.internal.state.model.AgentToolContext;
import com.mulesoft.modules.agent.broker.internal.tool.Tool;
import com.mulesoft.modules.agent.broker.internal.tool.ToolRequest;
import com.mulesoft.modules.agent.broker.internal.tool.ToolResponse;
import com.mulesoft.modules.agent.broker.internal.tool.a2a.A2AMessage;
import com.mulesoft.modules.agent.broker.internal.tool.a2a.A2AToolResponse;
import com.mulesoft.modules.agent.broker.internal.tool.a2a.AgentSummary;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A2AToolService
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(A2AToolService.class);
    private static final String A2A = "A2A";
    private static final DataType AGENT_SUMMARY_DATA_TYPE = DataType.fromType(AgentSummary.class);
    private static final DataType A2A_TOOL_RESPONSE_DATA_TYPE = DataType.fromType(A2AToolResponse.class);
    private final Map<String, Tool> tools = new ConcurrentHashMap<String, Tool>();
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExpressionManager expressionManager;
    private DwConverter a2aMessageWriter;
    private DwConverter a2aToolResponseReader;
    private DwConverter agentSummaryWriter;

    public void initialise() throws InitialisationException {
        this.a2aMessageWriter = new DwConverter(this.expressionManager, "%dw 2.0\noutput application/json\n---\n{\n  message: {\n      role: \"agent\",\n      parts: [{\n          \"type\": \"text\",\n           text: payload.userInput\n      }],\n      messageId: uuid(),\n      (referenceTaskIds: [payload.taskId]) if (payload.taskId != null),\n      (contextId: payload.contextId) if (payload.contextId != null)\n  }\n}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.fromObject((Object)value))));
        this.a2aToolResponseReader = new DwConverter(this.expressionManager, "%dw 2.0\noutput application/java\n---\n {\n    result: payload.artifacts\n       flatMap((artifact) ->\n         artifact.parts filter ($.'kind' == \"text\") map ((part) -> part.text)\n       )\n       joinBy \"\n\n\",\n    status: payload.status.state,\n    (taskId: payload.id) if (payload.id?),\n    (contextId: payload.contextId) if (payload.contextId?)\n\n }\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.agentSummaryWriter = new DwConverter(this.expressionManager, "%dw 2.0\noutput application/java\nvar parsedPayload = read(payload, \"application/json\")\nvar baseDescription = parsedPayload.description default \"\"\nvar skills = parsedPayload.skills default []\nvar skillsSummary = \"\n\nAvailable skills:\n\" ++ ((skills map (\"\u00e2\u0080\u00a2 \" ++ $.name ++ \": \" ++ $.description)) joinBy \"\n\")\nvar inputModes = parsedPayload.defaultInputModes default []\nvar outputModes = parsedPayload.defaultOutputModes default []\nvar inputDescription = \"Accepts input in formats: \" ++ (inputModes joinBy \", \")\nvar outputDescription = \"Returns output in formats: \" ++ (outputModes joinBy \", \")\n---\n{\n    name: parsedPayload.name,\n    description: baseDescription ++ skillsSummary,\n    inputDescription: inputDescription,\n    outputDescription: outputDescription\n}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.STRING)));
    }

    public CompletableFuture<Map<String, Tool>> getTools(List<A2AClient> a2aClients, ExtensionsClient extensionsClient) {
        if (null == a2aClients || a2aClients.isEmpty()) {
            return CompletableFuture.completedFuture(Map.of());
        }
        ConcurrentHashMap<String, Tool> collectedTools = new ConcurrentHashMap<String, Tool>();
        AtomicInteger countDown = new AtomicInteger(a2aClients.size());
        CompletableFuture<Map<String, Tool>> future = new CompletableFuture<Map<String, Tool>>();
        try {
            for (A2AClient a2aClient : a2aClients) {
                String a2aConfigRef = a2aClient.getA2AClientConfigRef();
                Tool tool = this.tools.get(a2aConfigRef);
                if (tool != null) {
                    this.collect(tool, collectedTools, countDown, future);
                    continue;
                }
                this.schedulerService.ioScheduler().submit(() -> {
                    try {
                        this.collect(this.tools.computeIfAbsent(a2aConfigRef, key -> {
                            AgentSummary agentSummary = this.fetchAgentSummary((String)key, countDown, future, extensionsClient);
                            return new A2ATool(agentSummary.getName(), agentSummary.getDescription(), agentSummary.getInputDescription(), agentSummary.getOutputDescription(), a2aConfigRef);
                        }), collectedTools, countDown, future);
                    }
                    catch (Exception e) {
                        this.handleDiscoveryException(countDown, future, e, a2aConfigRef);
                    }
                });
            }
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private AgentSummary fetchAgentSummary(String a2aConfigRef, AtomicInteger countDown, CompletableFuture<Map<String, Tool>> toolHandlersFuture, ExtensionsClient extensionsClient) {
        LOGGER.debug("Cache miss for config: {}. Attempting to fetch agent card...", (Object)a2aConfigRef);
        try {
            Result result = (Result)extensionsClient.execute(A2A, "getCard", params -> params.withConfigRef(a2aConfigRef)).get();
            Object output = result.getOutput();
            String cardJson = (String)output;
            AgentSummary parsedAgentData = (AgentSummary)this.agentSummaryWriter.evaluate(new TypedValue((Object)cardJson, DataType.STRING), AGENT_SUMMARY_DATA_TYPE);
            LOGGER.debug("Successfully parsed AgentSummary for config {}: name={}, description={}", new Object[]{a2aConfigRef, parsedAgentData.getName(), parsedAgentData.getDescription()});
            return parsedAgentData;
        }
        catch (ExecutionException e) {
            this.handleDiscoveryException(countDown, toolHandlersFuture, (Throwable)new ModuleException("Failed to fetch agent card for config '%s'".formatted(a2aConfigRef), (ErrorTypeDefinition)BrokerErrorTypes.TOOL_ERROR, e.getCause()), a2aConfigRef);
            return null;
        }
        catch (InterruptedException e) {
            this.handleDiscoveryException(countDown, toolHandlersFuture, (Throwable)new ModuleException("Fetch agent card for config %s was interrupted.".formatted(a2aConfigRef), (ErrorTypeDefinition)BrokerErrorTypes.TOOL_ERROR, e.getCause()), a2aConfigRef);
            return null;
        }
    }

    private void collect(Tool tool, Map<String, Tool> tools, AtomicInteger countDown, CompletableFuture<Map<String, Tool>> future) {
        tools.put(tool.getName(), tool);
        if (countDown.decrementAndGet() <= 0) {
            future.complete(tools);
        }
    }

    private void handleDiscoveryException(AtomicInteger countDown, CompletableFuture<?> toolHandlersFuture, Throwable t, String a2aConfigRef) {
        toolHandlersFuture.completeExceptionally((Throwable)new ModuleException("Exception discovering agent from A2A Client config %s: %s".formatted(a2aConfigRef, t.getMessage()), (ErrorTypeDefinition)BrokerErrorTypes.TOOL_ERROR, t));
        countDown.set(-1);
    }

    private String writeA2AMessage(ToolRequest request) {
        String toolName = request.getToolName();
        String toolInput = request.getToolInput();
        AgentToolContext toolContext = request.getTaskContext().getAgentToolContext(toolName);
        String contextId = toolContext.getContextId();
        String taskId = toolContext.getTaskId();
        LOGGER.debug("Building A2A message for agent {}: userInput={}, contextId={} taskId={}", new Object[]{toolName, toolInput, contextId, taskId});
        A2AMessage message = new A2AMessage(toolInput, contextId, taskId);
        return this.a2aMessageWriter.evaluateAsString(message, DataType.JSON_STRING);
    }

    private class A2ATool
    extends Tool {
        private final String configRef;

        private A2ATool(String name, String description, String input, String output, String configRef) {
            super(name, name, description, input, output);
            this.configRef = configRef;
        }

        @Override
        public CompletableFuture<ToolResponse> execute(ToolRequest request, ExtensionsClient extensionsClient) {
            try {
                String a2AMessage = A2AToolService.this.writeA2AMessage(request);
                return extensionsClient.execute(A2AToolService.A2A, "sendMessage", params -> ((OperationParameterizer)params.withConfigRef(this.configRef)).withParameter("message", (Object)new ByteArrayInputStream(a2AMessage.getBytes()))).thenApply(result -> (ToolResponse)A2AToolService.this.a2aToolResponseReader.evaluate(result.getOutput(), A2A_TOOL_RESPONSE_DATA_TYPE));
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture((Throwable)new ModuleException("Failed to invoke Agent " + request.getToolName(), (ErrorTypeDefinition)BrokerErrorTypes.TOOL_ERROR, (Throwable)e));
            }
        }
    }
}

