/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.openai;

import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAISettings;
import com.mulesoft.modules.agent.broker.internal.llm.LLMOrchestrationRequest;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;
import com.openai.models.Reasoning;
import com.openai.models.ReasoningEffort;
import com.openai.models.responses.ResponseCreateParams;
import com.openai.models.responses.StructuredResponseCreateParams;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class OpenAIClient
implements LLMClient {
    private com.openai.client.OpenAIClient client;
    private final OpenAISettings settings;

    public OpenAIClient(com.openai.client.OpenAIClient client, OpenAISettings settings) {
        this.client = client;
        this.settings = settings;
    }

    @Override
    public CompletableFuture<LLMOutput> reasonNextStep(LLMOrchestrationRequest request) {
        StructuredResponseCreateParams createParams = ResponseCreateParams.builder().input(request.getPrompt()).text(LLMOutput.class).model(this.settings.getModelName()).reasoning(Reasoning.builder().effort(ReasoningEffort.of((String)this.settings.getReasoningEffort().name().toLowerCase())).build()).build();
        return this.client.async().responses().create(createParams).thenApply(response -> (LLMOutput)response.output().stream().flatMap(item -> item.message().stream()).flatMap(message -> message.content().stream()).flatMap(content -> content.outputText().stream()).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"LLM provided wrong response format"))));
    }

    @Override
    public void close() {
        this.client.close();
    }
}

