/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.tool.mcp;

import com.mulesoft.modules.agent.broker.api.model.mcp.McpServer;
import com.mulesoft.modules.agent.broker.api.model.mcp.ToolFilter;
import com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes;
import com.mulesoft.modules.agent.broker.internal.serializer.DwConverter;
import com.mulesoft.modules.agent.broker.internal.tool.Tool;
import com.mulesoft.modules.agent.broker.internal.tool.ToolRequest;
import com.mulesoft.modules.agent.broker.internal.tool.ToolResponse;
import com.mulesoft.modules.agent.broker.internal.tool.mcp.McpToolInfo;
import com.mulesoft.modules.agent.broker.internal.tool.mcp.McpToolResponse;
import com.mulesoft.modules.agent.broker.internal.util.ExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class McpService
implements Initialisable {
    private static final DataType MAP_DATA_TYPE = DataType.fromType(Map.class);
    private static final DataType MCP_TOOL_INFO_DATA_TYPE = DataType.fromType(McpToolInfo.class);
    private static final String MCP = "MCP";
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private SchedulerService schedulerService;
    private final Map<String, List<Tool>> toolsByServer = new ConcurrentHashMap<String, List<Tool>>();
    private DwConverter mapWriter;
    private DwConverter toolInfoReader;
    private DwConverter jsonWriter;

    public void initialise() throws InitialisationException {
        this.mapWriter = new DwConverter(this.expressionManager, "%dw 2.0 output application/java --- payload", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.fromObject((Object)value))));
        this.toolInfoReader = new DwConverter(this.expressionManager, "%dw 2.0\noutput application/java\n---\n  {\n    toolName: payload.name,\n    description: payload.description,\n    \"input\": payload.inputSchema,\n    \"output\": \"A standard MCP response, such as Text, Blob or image type. Blobs and image responses will be base64 encoded\"\n  }\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, MAP_DATA_TYPE)));
        this.jsonWriter = new DwConverter(this.expressionManager, "%dw 2.0\noutput application/java\n---\nwrite(payload, \"json\") as String\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.fromObject((Object)value))));
    }

    public CompletableFuture<Map<String, Tool>> getTools(List<McpServer> mcpServers, ExtensionsClient extensionsClient) {
        if (null == mcpServers || mcpServers.isEmpty()) {
            return CompletableFuture.completedFuture(Map.of());
        }
        return new McpDiscovery(mcpServers, extensionsClient).getDiscoveredTools();
    }

    private class McpDiscovery {
        private final List<McpServer> mcpServers;
        private final Map<String, Tool> discoveredTools = new ConcurrentHashMap<String, Tool>();
        private final AtomicInteger countDown;
        private final CompletableFuture<Map<String, Tool>> future = new CompletableFuture();
        private final ExtensionsClient extensionsClient;

        private McpDiscovery(List<McpServer> mcpServers, ExtensionsClient extensionsClient) {
            this.mcpServers = mcpServers;
            this.countDown = new AtomicInteger(mcpServers.size());
            this.extensionsClient = extensionsClient;
        }

        public CompletableFuture<Map<String, Tool>> getDiscoveredTools() {
            try {
                for (McpServer mcpServer : this.mcpServers) {
                    String mcpConfigRef = mcpServer.getMcpClientConfigRef();
                    List<Tool> mcpTools = McpService.this.toolsByServer.get(mcpConfigRef);
                    if (mcpTools != null) {
                        this.collect(mcpTools);
                        continue;
                    }
                    McpService.this.schedulerService.ioScheduler().submit(() -> this.fetchTools(mcpServer));
                }
            }
            catch (Exception ex) {
                this.future.completeExceptionally(ex);
            }
            return this.future;
        }

        private void fetchTools(McpServer mcpServer) {
            String mcpConfigRef = mcpServer.getMcpClientConfigRef();
            this.extensionsClient.execute(McpService.MCP, "listTools", params -> params.withConfigRef(mcpConfigRef)).whenComplete((result, t) -> {
                if (t != null) {
                    this.handleToolParsingException(this.countDown, ExceptionUtils.unwrap(t), mcpConfigRef);
                } else {
                    try {
                        List<Tool> tools = this.createTools(mcpServer, (Result<Object, Object>)result, mcpConfigRef);
                        if (!tools.isEmpty()) {
                            this.collect(tools);
                            McpService.this.toolsByServer.put(mcpConfigRef, tools);
                        }
                    }
                    catch (Exception e) {
                        this.handleToolParsingException(this.countDown, e, mcpConfigRef);
                    }
                }
            });
        }

        private List<Tool> createTools(McpServer mcpServer, Result<Object, Object> result, String mcpConfigRef) {
            Iterator iterator = (Iterator)result.getOutput();
            ArrayList<Tool> tools = new ArrayList<Tool>();
            iterator.forEachRemaining(value -> {
                McpToolInfo toolInfo = (McpToolInfo)McpService.this.toolInfoReader.evaluate(value, MCP_TOOL_INFO_DATA_TYPE);
                String toolName = toolInfo.getToolName();
                if (this.isAllowed(toolName, mcpServer.getToolsFilter())) {
                    McpTool tool = new McpTool(mcpConfigRef + "." + toolName, toolName, toolInfo.getDescription(), toolInfo.getInput(), toolInfo.getOutput(), mcpConfigRef);
                    tools.add(tool);
                }
            });
            return tools;
        }

        private void collect(Collection<Tool> tools) {
            tools.forEach(tool -> this.discoveredTools.put(tool.getId(), (Tool)tool));
            if (this.countDown.decrementAndGet() <= 0) {
                this.future.complete(this.discoveredTools);
            }
        }

        private boolean isAllowed(String toolName, ToolFilter filter) {
            List<String> values = filter.getAllowedTools();
            if (values != null && !values.isEmpty()) {
                return values.contains(toolName);
            }
            values = filter.getDisallowedTools();
            if (values != null && !values.isEmpty()) {
                return !values.contains(toolName);
            }
            return true;
        }

        private void handleToolParsingException(AtomicInteger countDown, Throwable t, String mcpConfigRef) {
            this.future.completeExceptionally((Throwable)new ModuleException("Exception obtaining toolList from MCP client config %s: %s".formatted(mcpConfigRef, t.getMessage()), (ErrorTypeDefinition)BrokerErrorTypes.TOOL_ERROR, t));
            countDown.set(-1);
        }

        private class McpTool
        extends Tool {
            private final String configRef;

            private McpTool(String id, String name, String description, String input, String output, String configRef) {
                super(id, name, description, input, output);
                this.configRef = configRef;
            }

            @Override
            public CompletableFuture<ToolResponse> execute(ToolRequest request, ExtensionsClient extensionsClient) {
                try {
                    return extensionsClient.execute(McpService.MCP, "callTool", params -> ((OperationParameterizer)((OperationParameterizer)params.withConfigRef(this.configRef)).withParameter("toolName", (Object)this.getName())).withParameter("arguments", McpService.this.mapWriter.evaluate(new TypedValue((Object)request.getToolInput(), DataType.JSON_STRING), MAP_DATA_TYPE))).thenApply(result -> new McpToolResponse(McpService.this.jsonWriter.evaluateAsString(result.getOutput(), DataType.JSON_STRING)));
                }
                catch (Exception e) {
                    return CompletableFuture.failedFuture((Throwable)new ModuleException("Failed to invoke MCP tool " + request.getToolName(), (ErrorTypeDefinition)BrokerErrorTypes.TOOL_ERROR, (Throwable)e));
                }
            }
        }
    }
}

