/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.openai;

import com.mulesoft.modules.agent.broker.internal.extension.connection.BaseConnectionProvider;
import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.InsecureTrustManager;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAIClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAISettings;
import com.openai.client.okhttp.OpenAIOkHttpClient;
import javax.net.ssl.X509TrustManager;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;

@Alias(value="openai")
public class OpenAIConnectionProvider
extends BaseConnectionProvider
implements CachedConnectionProvider<LLMClient>,
NoConnectivityTest,
Initialisable {
    @ParameterGroup(name="OpenAI Settings")
    private OpenAISettings openAISettings;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="TLS")
    private TlsContextFactory tlsContextFactory;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
    }

    public LLMClient connect() throws ConnectionException {
        OpenAIOkHttpClient.Builder builder = OpenAIOkHttpClient.builder().apiKey(this.openAISettings.getApiKey());
        if (this.openAISettings.getUrl() != null) {
            builder.baseUrl(this.openAISettings.getUrl());
        }
        if (this.tlsContextFactory != null) {
            if (this.tlsContextFactory.getTrustStoreConfiguration().isInsecure()) {
                try {
                    builder.sslSocketFactory(this.tlsContextFactory.createSocketFactory()).trustManager((X509TrustManager)new InsecureTrustManager());
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create SSL Socket factory"), (Throwable)e);
                }
            } else {
                LOGGER.info("Secure custom TLS context is not supported for OpenAI. Ignoring and using default instead");
            }
        }
        return new OpenAIClient(builder.build(), this.openAISettings);
    }

    public ConnectionValidationResult validate(LLMClient llmClient) {
        return ConnectionValidationResult.success();
    }
}

