/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */

package com.mulesoft.modules.agent.broker.internal.state.model;

import static io.a2a.spec.TaskState.UNKNOWN;

import java.io.Serializable;

import io.a2a.spec.TaskState;

public class ConversationState implements Serializable {

  private AdditionalInputRequired additionalInputRequired;
  private TaskState taskState = UNKNOWN;
  private String errorMessage;

  public ConversationState() {}

  public ConversationState(TaskState taskState, String errorMessage) {
    this.taskState = taskState;
    this.errorMessage = errorMessage;
  }

  public TaskState getTaskState() {
    return taskState;
  }

  public void setTaskState(TaskState taskState) {
    this.taskState = taskState;
  }

  public AdditionalInputRequired getAdditionalInputRequired() {
    return additionalInputRequired;
  }

  public void setAdditionalInputRequired(AdditionalInputRequired additionalInputRequired) {
    this.additionalInputRequired = additionalInputRequired;
  }

  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }
}
