/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */

package com.mulesoft.modules.agent.broker.internal.state.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TaskContext implements Serializable {

  private static final long serialVersionUID = 1L;

  private String taskId;
  private String conversationId;
  private int currentIteration = 0;
  private List<Iteration> iterations = new ArrayList<>();
  private ConversationState conversationState = new ConversationState();
  private String conversationHistory = "";
  private Map<String, AgentToolContext> agentToolContexts = new ConcurrentHashMap<>();
  private Set<String> referencedTaskIds = new LinkedHashSet<>();

  public TaskContext(String taskId, String conversationId) {
    this.taskId = taskId;
    this.conversationId = conversationId;
  }

  public String getConversationId() {
    return conversationId;
  }

  public String getTaskId() {
    return taskId;
  }

  public AgentToolContext getAgentToolContext(String toolName) {
    return agentToolContexts.computeIfAbsent(toolName, t -> new AgentToolContext());
  }

  public void addIteration(Iteration iteration) {
    this.iterations.add(iteration);
  }

  public Iteration getLastIteration() {
    if (iterations.isEmpty()) {
      Iteration iteration = new Iteration();
      addIteration(iteration);

      return iteration;
    } else {
      return iterations.get(iterations.size() - 1);
    }
  }

  public List<Iteration> getIterations() {
    return iterations;
  }

  public ConversationState getConversationState() {
    return conversationState;
  }

  public String getConversationHistory() {
    return conversationHistory;
  }

  public int getCurrentIteration() {
    return currentIteration;
  }

  public void setCurrentIteration(int currentIteration) {
    this.currentIteration = currentIteration;
  }

  public void setConversationState(ConversationState conversationState) {
    this.conversationState = conversationState;
  }

  public void setConversationHistory(String conversationHistory) {
    this.conversationHistory = conversationHistory;
  }

  public void refines(TaskContext taskContext) {
    setConversationState(taskContext.getConversationState());
    setConversationHistory(taskContext.getConversationHistory());
    agentToolContexts = new ConcurrentHashMap<>(taskContext.agentToolContexts);
  }

  public Set<String> getReferencedTaskIds() {
    return referencedTaskIds;
  }
}
