/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.tool;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.client.ExtensionsClient;

import java.util.concurrent.CompletableFuture;

public abstract class Tool {

  private String id;
  private String name;
  private String description;
  private String input;
  private String output;

  public Tool(String id, String name, String description, String input, String output) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.input = input;
    this.output = output;
  }

  public abstract CompletableFuture<ToolResponse> execute(ToolRequest request, ExtensionsClient extensionsClient);

  public String getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public String getInput() {
    return input;
  }

  public String getOutput() {
    return output;
  }

  /**
   * Create a map of headers to be sent when executing a tool.
   *
   * @param request the tool request
   * @return a map of header properties
   */
  protected MultiMap<String, String> collectHeaders(ToolRequest request) {
    MultiMap<String, String> headers = new MultiMap<>();
    String apiInstanceId = request.getApiInstanceId();
    if (apiInstanceId != null && !apiInstanceId.isBlank()) {
      headers.put("X-ANYPOINT-API-INSTANCE-ID", request.getApiInstanceId());
    }
    return headers;
  }
}
