/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.tool;

import com.mulesoft.modules.agent.broker.internal.state.model.TaskContext;

public class ToolRequest {

  private String toolName;
  private String toolInput;
  private String reasoning;
  private int iterationNumber;
  private TaskContext taskContext;
  private String apiInstanceId;

  public ToolRequest(String toolName, String toolInput, String reasoning, int iterationNumber, TaskContext taskContext,
                     String apiInstanceId) {
    this.toolName = toolName;
    this.toolInput = toolInput;
    this.reasoning = reasoning;
    this.iterationNumber = iterationNumber;
    this.taskContext = taskContext;
    this.apiInstanceId = apiInstanceId;
  }

  public String getToolName() {
    return toolName;
  }

  public String getToolInput() {
    return toolInput;
  }

  public String getReasoning() {
    return reasoning;
  }

  public int getIterationNumber() {
    return iterationNumber;
  }

  public TaskContext getTaskContext() {
    return taskContext;
  }

  public String getApiInstanceId() {
    return apiInstanceId;
  }
}
