/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.tracing;

import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

import com.mulesoft.modules.agent.broker.internal.extension.AgentsBroker;

public final class TracingUtils {

  private static final String ARTIFACT_TYPE = "artifact.type";
  private static final String AGENT_NAME = "agent.name";
  private static final String AGENT_BROKER = "agent/broker";
  private static final String API_INSTANCE_ID = "mulesoft.api.instance.id";

  private TracingUtils() {}

  public static void traceBroker(AgentsBroker agent,
                                 String apiInstanceId,
                                 DistributedTraceContextManager contextManager) {
    contextManager.setCurrentSpanName("[BROKER] " + agent.getConfigName());
    contextManager.addCurrentSpanAttribute(ARTIFACT_TYPE, AGENT_BROKER);
    contextManager.addCurrentSpanAttribute(AGENT_NAME, agent.getConfigName());

    if (apiInstanceId != null) {
      contextManager.addCurrentSpanAttribute(API_INSTANCE_ID, apiInstanceId);
    }
  }
}
