/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.datasense;

import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.sdk.api.metadata.ChainInputMetadataContext;
import org.mule.sdk.api.metadata.resolving.ChainInputTypeResolver;

import com.mulesoft.modules.agent.broker.internal.tool.ToolRequest;

public class ToolInputResolver implements ChainInputTypeResolver {

  @Override
  public MessageMetadataType getChainInputMetadataType(ChainInputMetadataContext context)
      throws MetadataResolvingException, ConnectionException {
    var builder = MessageMetadataType.builder()
        .payload(context.getTypeLoader().load(ToolRequest.class));

    builder.attributes().voidType();
    return builder.build();
  }

  @Override
  public String getCategoryName() {
    return "tools";
  }

  @Override
  public String getResolverName() {
    return getClass().getSimpleName();
  }
}
