/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection;

import static org.slf4j.LoggerFactory.getLogger;

import org.mule.runtime.api.connection.ConnectionProvider;

import org.slf4j.Logger;

public abstract class BaseConnectionProvider implements ConnectionProvider<LLMClient> {

  protected final static Logger LOGGER = getLogger(BaseConnectionProvider.class);

  @Override
  public final void disconnect(LLMClient connection) {
    try {
      connection.close();
    } catch (Exception e) {
      LOGGER.error("Error while closing connection", e);
    }
  }
}
