/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.einstein;

import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.DEFAULT_GROUP_NAME;

import org.mule.runtime.extension.api.client.ExtensionsClient;

import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.llm.LLMOrchestrationRequest;
import com.mulesoft.modules.agent.broker.internal.serializer.SerializationService;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

public class EinsteinClient implements LLMClient {

  private static final String EXTENSION_NAME = "Einstein AI";
  private static final String SETTINGS_PARAM_GROUP = "Additional properties";

  private final String configRef;
  private final EinsteinSettings settings;
  private final ExtensionsClient extensionsClient;
  private final SerializationService serializationService;

  public EinsteinClient(String configRef,
                        EinsteinSettings settings,
                        ExtensionsClient extensionsClient,
                        SerializationService serializationService) {
    this.extensionsClient = extensionsClient;
    this.configRef = configRef;
    this.settings = settings;
    this.serializationService = serializationService;
  }

  @Override
  public CompletableFuture<LLMOutput> reasonNextStep(LLMOrchestrationRequest request) {
    return extensionsClient.<InputStream, Object>execute(EXTENSION_NAME, "CHAT-answer-prompt", params -> {
      params.withConfigRef(configRef)
          .withParameter(DEFAULT_GROUP_NAME, "prompt", request.getPrompt())
          .withParameter(SETTINGS_PARAM_GROUP, "modelApiName", settings.getModelApiName())
          .withParameter(SETTINGS_PARAM_GROUP, "probability", settings.getProbability())
          .withParameter(SETTINGS_PARAM_GROUP, "locale", settings.getLocale());
    }).thenApply(result -> serializationService.parseEinsteinOutput(result.getOutput()));
  }

  @Override
  public void close() {

  }
}
