/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.einstein;

import static org.mule.runtime.api.connection.ConnectionValidationResult.success;

import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;

import com.mulesoft.modules.agent.broker.internal.extension.connection.BaseConnectionProvider;
import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.serializer.SerializationService;

import javax.inject.Inject;

@Alias("einstein")
public class EinsteinConnectionProvider extends BaseConnectionProvider
    implements CachedConnectionProvider<LLMClient>, NoConnectivityTest {

  @Inject
  private ExtensionsClient extensionsClient;

  @Inject
  private SerializationService serializationService;

  @Parameter
  @ConfigReference(namespace = "MS-EINSTEIN-AI", name = "CONFIG")
  private String einsteinAiConfigRef;

  @ParameterGroup(name = "Model settings")
  private EinsteinSettings settings;

  @Override
  public LLMClient connect() throws ConnectionException {
    return new EinsteinClient(einsteinAiConfigRef, settings, extensionsClient, serializationService);
  }

  @Override
  public ConnectionValidationResult validate(LLMClient connection) {
    return success();
  }
}
