/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.einstein;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

public class EinsteinSettings {

  private static final String MODELAPI_OPENAI_GPT_3_5_TURBO = "sfdc_ai__DefaultOpenAIGPT35Turbo";

  @Parameter
  @Optional(defaultValue = MODELAPI_OPENAI_GPT_3_5_TURBO)
  @DisplayName("Model API Name")
  private String modelApiName;

  @Parameter
  @Optional(defaultValue = "0.8")
  @DisplayName("Probability")
  private Double probability;

  @Parameter
  @Optional(defaultValue = "en_US")
  @DisplayName("Locale")
  private String locale;

  public String getModelApiName() {
    return modelApiName;
  }

  public Double getProbability() {
    return probability;
  }

  public String getLocale() {
    return locale;
  }
}
