/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.operation.loop;

import static com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes.A2A;
import static com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes.LLM_ERROR;
import static com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes.MAX_LOOPS;
import static com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes.REASONING_ERROR;
import static com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes.TOOL_ERROR;

import static java.util.Set.of;

import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

import java.util.Set;

/**
 * Returns the common error types that most likely apply to any component
 */
public class LoopErrorTypeProvider implements ErrorTypeProvider {

  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    return of(MAX_LOOPS, LLM_ERROR, TOOL_ERROR, REASONING_ERROR, A2A);
  }
}
