/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.state.jackson;

import static io.a2a.util.Utils.OBJECT_MAPPER;

import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;

import java.io.IOException;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class LLMOutputDeserializer extends StdDeserializer<LLMOutput> {

  public LLMOutputDeserializer() {
    super(LLMOutput.class);
  }

  @Override
  public LLMOutput deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JacksonException {
    JsonNode node = parser.getCodec().readTree(parser);
    return new LLMOutput(
                         getString(node, "toolToCall"),
                         getString(node, "toolInput"),
                         getString(node, "result"),
                         getString(node, "reasoning"),
                         getBoolean(node, "additionalInputRequired"),
                         getBoolean(node, "goalComplete"));
  }

  private String getString(JsonNode node, String fieldName) throws IOException {
    JsonNode fieldNode = node.get(fieldName);
    if (fieldNode == null) {
      return "";
    } else if (fieldNode.isObject()) {
      return OBJECT_MAPPER.writeValueAsString(fieldNode);
    }

    return fieldNode.asText();
  }

  public boolean getBoolean(JsonNode node, String fieldName) throws IOException {
    JsonNode fieldNode = node.get(fieldName);
    return fieldNode != null ? fieldNode.asBoolean() : false;
  }
}
