/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.state.model;

import com.mulesoft.modules.agent.broker.internal.state.jackson.LLMOutputDeserializer;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonDeserialize(using = LLMOutputDeserializer.class)
public class LLMOutput implements Serializable {

  private String toolToCall;
  private String toolInput;
  private String result;
  private String reasoning;
  private boolean additionalInputRequired;
  private boolean goalComplete;

  public LLMOutput(String toolToCall,
                   String toolInput,
                   String result,
                   String reasoning,
                   boolean additionalInputRequired,
                   boolean goalComplete) {
    this.toolToCall = toolToCall;
    this.toolInput = toolInput;
    this.result = result;
    this.reasoning = reasoning;
    this.additionalInputRequired = additionalInputRequired;
    this.goalComplete = goalComplete;
  }

  public String getToolToCall() {
    return toolToCall;
  }

  public String getToolInput() {
    return toolInput;
  }

  public String getReasoning() {
    return reasoning;
  }

  public boolean isGoalComplete() {
    return goalComplete;
  }

  public String getResult() {
    return result;
  }

  public boolean isAdditionalInputRequired() {
    return additionalInputRequired;
  }

}
