/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public final class ConcurrencyUtils {

  public static <T> void completeAsyncInTCCL(CompletableFuture<T> future,
                                             Executor executor,
                                             BiConsumer<? super T, ? super Throwable> action) {
    future.whenCompleteAsync((result, error) -> {
      final var thread = Thread.currentThread();
      final ClassLoader originalTccl = thread.getContextClassLoader();
      thread.setContextClassLoader(ConcurrencyUtils.class.getClassLoader());
      try {
        action.accept(result, error);
      } finally {
        thread.setContextClassLoader(originalTccl);
      }
    }, executor);
  }

  private ConcurrencyUtils() {}
}
